package com.tykj.dev.rfid.service.impl;

import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.task.subject.common.BusinessEnum;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.vo.FileVo;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.util.AuthenticationUtils;
import com.tykj.dev.misc.utils.ListUtil;
import com.tykj.dev.rfid.entity.domin.RfidChangeBill;
import com.tykj.dev.rfid.entity.domin.RfidChangeLog;
import com.tykj.dev.rfid.entity.enums.RfidChangeStatus;
import com.tykj.dev.rfid.entity.vo.RfidFormVo;
import com.tykj.dev.rfid.repository.RfidChangeBillDao;
import com.tykj.dev.rfid.repository.RfidChangeLogDao;
import com.tykj.dev.rfid.service.RfidChangeBillService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class RfidChangeBillEntityServiceImpl
 * @packageName com.tykj.dev.rfid.service.impl
 **/
@Service
public class RfidChangeBillServiceImpl implements RfidChangeBillService {

    @Autowired
    RfidChangeBillDao rfidChangeBillDao;

    @Autowired
    RfidChangeLogDao rfidChangeLogDao;

    @Override
    public RfidChangeBill addEntity(RfidChangeBill libraryWarningLogEntity) {
        return rfidChangeBillDao.save(libraryWarningLogEntity);
    }

    @Override
    public RfidChangeBill updateEntity(RfidChangeBill libraryWarningLogEntity) {
        return rfidChangeBillDao.save(libraryWarningLogEntity);
    }

    @Override
    public RfidChangeBill getOne(Integer id) {
        return rfidChangeBillDao.getOne(id);
    }

}
