/*
 * Decompiled with CFR 0.152.
 */
package com.rfid.bean;

public class MessageTran {
    private byte btPacketType;
    private byte btDataLen;
    private byte btReadId;
    private byte btCmd;
    private byte[] btAryData;
    private byte btCheck;
    private byte[] btAryTranData;

    public MessageTran() {
    }

    public MessageTran(byte btReadId, byte btCmd, byte[] btAryData) {
        int nLen = btAryData.length;
        this.btPacketType = (byte)-96;
        this.btDataLen = (byte)(nLen + 3);
        this.btReadId = btReadId;
        this.btCmd = btCmd;
        this.btAryData = new byte[nLen];
        System.arraycopy(btAryData, 0, this.btAryData, 0, btAryData.length);
        this.btAryTranData = new byte[nLen + 5];
        this.btAryTranData[0] = this.btPacketType;
        this.btAryTranData[1] = this.btDataLen;
        this.btAryTranData[2] = this.btReadId;
        this.btAryTranData[3] = this.btCmd;
        System.arraycopy(this.btAryData, 0, this.btAryTranData, 4, this.btAryData.length);
        this.btAryTranData[nLen + 4] = this.btCheck = this.checkSum(this.btAryTranData, 0, nLen + 4);
    }

    public MessageTran(byte btReadId, byte btCmd) {
        this.btPacketType = (byte)-96;
        this.btDataLen = (byte)3;
        this.btReadId = btReadId;
        this.btCmd = btCmd;
        this.btAryTranData = new byte[5];
        this.btAryTranData[0] = this.btPacketType;
        this.btAryTranData[1] = this.btDataLen;
        this.btAryTranData[2] = this.btReadId;
        this.btAryTranData[3] = this.btCmd;
        this.btAryTranData[4] = this.btCheck = this.checkSum(this.btAryTranData, 0, 4);
    }

    public MessageTran(byte[] btAryTranData) {
        int nLen = btAryTranData.length;
        this.btAryTranData = new byte[nLen];
        System.arraycopy(btAryTranData, 0, this.btAryTranData, 0, btAryTranData.length);
        byte btCK = this.checkSum(this.btAryTranData, 0, this.btAryTranData.length - 1);
        if (btCK != btAryTranData[nLen - 1]) {
            return;
        }
        this.btPacketType = btAryTranData[0];
        this.btDataLen = btAryTranData[1];
        this.btReadId = btAryTranData[2];
        this.btCmd = btAryTranData[3];
        this.btCheck = btAryTranData[nLen - 1];
        if (nLen > 5) {
            this.btAryData = new byte[nLen - 5];
            int nloop = 0;
            while (nloop < nLen - 5) {
                this.btAryData[nloop] = btAryTranData[4 + nloop];
                ++nloop;
            }
        }
    }

    public byte[] getAryTranData() {
        return this.btAryTranData;
    }

    public byte[] getAryData() {
        return this.btAryData;
    }

    public byte getReadId() {
        return this.btReadId;
    }

    public byte getCmd() {
        return this.btCmd;
    }

    public byte getPacketType() {
        return this.btPacketType;
    }

    public boolean checkPacketType() {
        return this.btPacketType == -96;
    }

    public byte checkSum(byte[] btAryBuffer, int nStartPos, int nLen) {
        int btSum = 0;
        int nloop = nStartPos;
        while (nloop < nStartPos + nLen) {
            btSum = (byte)(btSum + btAryBuffer[nloop]);
            ++nloop;
        }
        return (byte)(~btSum + 1 & 0xFF);
    }
}

