package com.tykj.dev.device.repair.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("维修单存储类")
public class RepairBillSaveVo {

    @ApiModelProperty(value = "发起申请人",example = "1")
    private Integer startUseraId;

    @ApiModelProperty(value = "发起确认人",example = "1")
    private Integer startUserbId;

    @ApiModelProperty(value = "维修单位",example = "市机要局")
    private String receiveUnit;

    @ApiModelProperty(value = "发起单位",example = "市机要局")
    private String sendUnit;

    @ApiModelProperty(value = "维修经手人",example = "1")
    private Integer repairUseraId;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "签发人")
    private String agent;

    @ApiModelProperty(value = "出库附件文件名")
    private String fileName;

    @ApiModelProperty(value = "出库附件文件地址URL")
    private String fileUrl;

    @ApiModelProperty(value = "维修经手人")
    private String repairUserA;

    @ApiModelProperty(value = "应出库装备数量")
    private Integer sendingCount;

    @ApiModelProperty(value = "已出库装备数量")
    private Integer sendedCount;

    @ApiModelProperty(value = "送修装备出库详情(装备主键id+核对结果(0缺失1无误3新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增")
    private String repairDeviceCheckDetail;

    @ApiModelProperty(value = "送修装备出库检查结果")
    private String repairDeviceCheckResult;

    @ApiModelProperty(value = "维修装备详情列表")
    private List<DeviceDetailVo> deviceList;

    @ApiModelProperty(value = "任务Id")
    private Integer taskId;
}
