import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Conditions.java
 * @Description TODO
 * @createTime 2020年08月23日 13:56:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "报废装备查询条件", description = "报废装备查询条件")
public class ScrapConditions {
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty(value = "开始时间",example = "bmxx",name = "statusTime")
    private Date statusTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty(value = "结束时间",example = "bmxx",name = "endTime")
    private Date endTime;
    @ApiModelProperty(value = "模糊搜索",example = "bmxx",name = "dimName")
    private String dimName;
    @ApiModelProperty(value = "页数",example = "bmxx",name = "page")
    private Integer page;
    @ApiModelProperty(value = "条数",example = "bmxx",name = "size")
    private Integer size;
}
