package com.tykj.dev.device.sendback.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for send_back_bill
 * 清退账单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update send_back_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("清退账单")
public class SendBackBill {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 清退标题
	*/
	@ApiModelProperty(value = "清退标题")
	private String title;
	/**
	* 审核人id
	*/
	@ApiModelProperty(value = "审核人id")
	private Integer reviewUserId;
	/**
	* 截止时间
	*/
	@ApiModelProperty(value = "截止时间")
	private Date deadLine;
	/**
	* 涉及装备id(x作为分隔符),例如x1x2x,意为id为1,2的装备需要退回
	*/
	@ApiModelProperty(value = "涉及装备id(x作为分隔符),例如x1x2x,意为id为1,2的装备需要退回")
	private String involeDevice;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime = new Date();
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	@ApiModelProperty(value = "记录初始清退单")
	private String sendBackStatistical;

	@ApiModelProperty(value = "异常装备说明")
	private String exceptionDes;

	@ApiModelProperty(value = "出库单详情")
	private String sendBackOut;

	@ApiModelProperty(value = "出库单表格")
	private String sendBackOutForm;

	@ApiModelProperty(value = "清退单id")
	private Integer formId;

}
