package com.tykj.dev.device.task.repository;

import com.tykj.dev.device.task.subject.domin.Task;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface TaskDao extends JpaRepository<Task, Integer>, JpaSpecificationExecutor<Task> {

    /**
     * @param billId 账单id
     * @param businessType 业务类型
     * 根据账单Id和业务类型查询task
     */
    Task findByBillIdAndBusinessType(Integer billId, Integer businessType);

    /**
     * 根据账单id、业务类型、任务状态查询task
     * @param billId 账单id
     * @param businessType 业务类型
     * @param billStatus 任务状态
     */
    List<Task> findAllByBillIdAndBusinessTypeAndBillStatus(Integer billId,Integer businessType,Integer billStatus);


    /**
     * 根据账单id、业务类型、以及父id为null
     * @param billId 账单ID
     * @param businessType 业务类型
     */
    Task findAllByParentTaskIdIsNullAndBillIdAndBusinessType(Integer billId,Integer businessType);

    List<Task> findAllByParentTaskId(Integer parentTaskId);
}
