package com.tykj.dev.device.user.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zjm
 */
public class MyFilter extends UsernamePasswordAuthenticationFilter {
    @Autowired
    SessionRegistry sessionRegistry;

    @Override
    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
//        Cookie[] cookies = request.getCookies();
//        if(cookies==null){
//            return super.attemptAuthentication(request, response);
//        }
//        String value = cookies[0].getValue();
        if (request.getContentType().contains(MediaType.APPLICATION_JSON_VALUE) || request.getContentType().contains(MediaType.APPLICATION_JSON_UTF8_VALUE)) {
            Map<String, String> loginData = new HashMap<>();
            try {
                loginData = new ObjectMapper().readValue(request.getInputStream(), Map.class);
            } catch (IOException e) {
                System.out.println("myfile错误");
            }
            String username = loginData.get(getUsernameParameter());
            String password = loginData.get(getPasswordParameter());
            if (username == null) {
                username = "";
            }
            if (password == null) {
                password = "";
            }
            username = username.trim();
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(
                    username, password);
            setDetails(request, authRequest);
            SecurityUser principal = new SecurityUser();
            principal.setUsername(username);
            sessionRegistry.registerNewSession(request.getSession(true).getId(), principal);
            System.out.println("___"+request.getSession(true).getId());
            return this.getAuthenticationManager().authenticate(authRequest);
//        if (request.getContentType().equals(MediaType.APPLICATION_JSON_UTF8_VALUE) || request.getContentType().equals(MediaType.APPLICATION_JSON_VALUE)) {
//            ObjectMapper mapper = new ObjectMapper();
//            UsernamePasswordAuthenticationToken authRequest = null;
//            try (InputStream is = request.getInputStream()) {
//                Map<String, String> authenticationBean = mapper.readValue(is, Map.class);
//                authRequest = new UsernamePasswordAuthenticationToken(authenticationBean.get("username"), authenticationBean.get("password"));
//            } catch (IOException e) {
//                e.printStackTrace();
//                authRequest = new UsernamePasswordAuthenticationToken("", "");
//            } finally {
//                setDetails(request, authRequest);
//                SecurityUser principal = new SecurityUser();
//                principal.setUsername(username);
//                sessionRegistry.registerNewSession(request.getSession(true).getId(), principal);
//                return this.getAuthenticationManager().authenticate(authRequest);
//            }
        } else {
            SecurityUser principal = new SecurityUser();
            principal.setUsername(request.getParameter("username"));
            System.out.println("___"+request.getSession(true).getId());
            sessionRegistry.registerNewSession(request.getSession(true).getId(), principal);
            return super.attemptAuthentication(request, response);
        }
    }
}

