package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.base.ret.AreaVo;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.UnitsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitsController.java
 * @Description TODO
 * @createTime 2020年07月28日 11:12:00
 */
@RestController
@AutoDocument
@Api(tags = "用户模块", description = "提供用户相关的接口")
@RequestMapping("/units")
public class UnitsController {
    @Autowired
    UnitsService unitsService;

    @GetMapping(value = "/find/{unitsId}")
    @ApiOperation(value = "根据单位ID查询对象", notes = "返回单位对象")
    public ResponseEntity<Units> findUnits(@PathVariable Integer unitsId){
        return ResponseEntity.ok(unitsService.findById(unitsId));
    }

    @GetMapping(value = "/findAll/{level}")
    @ApiOperation(value = "根据等级查询对应等级的单位集合", notes = "单位集合")
    public ResponseEntity<List<Units>> deleteUser(@PathVariable Integer level){
        return ResponseEntity.ok(unitsService.findListById(level));
    }

    @GetMapping(value = "/findAll")
    @ApiOperation(value = "查询所有单位", notes = "单位集合")
    public ResponseEntity<List<Units>> findAlls(){
        return ResponseEntity.ok(unitsService.findAll());
    }

    @GetMapping(value = "/area")
    @ApiOperation(value = "根据等级查询对应等级的单位集合", notes = "单位集合")
    public ResponseEntity<List<AreaVo>> deleteUser(){
        return ResponseEntity.ok(unitsService.findListAreaUnitsVo());
    }


    @GetMapping(value = "/findAll/GreaterThanEqual/{level}")
    @ApiOperation(value = "根据当前用户的单位等级，查询所有的下级单位以及自己单位", notes = "单位集合")
    public ResponseEntity<List<Units>> GreaterThanEqualLeven(@PathVariable Integer level){
        return ResponseEntity.ok(unitsService.findListlevenGreaterThanEqual(level));
    }

    @GetMapping(value = "/find/units/{unitsId}")
    @ApiOperation(value = "根据当前用户的单位ID查询上级单位对象", notes = "单位")
    public ResponseEntity<Units> findLastUnits(@PathVariable Integer unitsId){
        return ResponseEntity.ok(unitsService.findByAreaId(unitsId));
    }
}
