package com.tykj.dev.rfid.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.rfid.entity.domin.RfidChangeLog;
import com.tykj.dev.rfid.entity.vo.RfidChangeLogSelectVo;
import com.tykj.dev.rfid.repository.RfidChangeLogDao;
import com.tykj.dev.rfid.service.RfidChangeLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class RfidChangeLogServiceImpl
 * @packageName com.tykj.dev.rfid.service.impl
 **/
@Service
public class RfidChangeLogServiceImpl implements RfidChangeLogService {

    @Autowired
    RfidChangeLogDao rfidChangeLogDao;

    @Override
    public RfidChangeLog getOne(Integer id) {
        return rfidChangeLogDao.getOne(id);
    }

    @Override
    public List<RfidChangeLog> getList(RfidChangeLogSelectVo rfidChangeLogSelectVo) {
        return rfidChangeLogDao.findAll(getSelectSpecification(rfidChangeLogSelectVo));

    }

    @Override
    public RfidChangeLog addEntity(RfidChangeLog rfidChangeLog) {
        return rfidChangeLogDao.save(rfidChangeLog);
    }

    @Override
    public RfidChangeLog updateEntity(RfidChangeLog rfidChangeLog) {
        return rfidChangeLogDao.save(rfidChangeLog);
    }


    private Specification<RfidChangeLog> getSelectSpecification(RfidChangeLogSelectVo rfidChangeLogSelectVo){
        PredicateBuilder<RfidChangeLog> predicateBuilder = Specifications.and();
        if (rfidChangeLogSelectVo!=null) {
            if(rfidChangeLogSelectVo.getValidTag()!=null){
                predicateBuilder.eq("validTag",rfidChangeLogSelectVo.getValidTag());
            }
            if(rfidChangeLogSelectVo.getBillId()!=null){
                predicateBuilder.eq("rfidChangeBillId",rfidChangeLogSelectVo.getBillId());
            }
            if (rfidChangeLogSelectVo.getDeviceId()!=null){
                predicateBuilder.eq("deviceId",rfidChangeLogSelectVo.getDeviceId());
            }
        }
        return predicateBuilder.build();
    }

}
