package com.tykj.dev.device.allot.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.allot.subject.vo.AllotBillSelectVo;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块",description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class AllotBillSelectController {

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private UserPublicService userService;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @ApiOperation(value = "查询配发单",notes = "可以通过这个接口查询配发单")
    @PostMapping(value = "/archives/allot/summary")
    public ResponseEntity<Page<AllotBill>> selectAllotBill(@RequestBody AllotBillSelectVo allotBillSelectVo){
        Page<AllotBill> page = allotBillService.getPage(allotBillSelectVo,allotBillSelectVo.getPageable());
        return ResultUtil.success(page);
    }

    @ApiOperation(value = "查询配发单详情页",notes = "可以通过这个接口查询配发单")
    @GetMapping(value = "/archives/allot/detail/{id}")
    public ResponseEntity<List<Object>> selectAllotBillDetail(@PathVariable("id") int id){
        List<Object> list = new ArrayList<>();
        AllotBill allotBillEntity = allotBillService.getOne(id);
        allotBillEntity.setSenderUserA(userService.getOne(allotBillEntity.getSendUseraId()).getName());
        allotBillEntity.setSenderUserB(userService.getOne(allotBillEntity.getSendUserbId()).getName());
        allotBillEntity.setReceiveUserA(userService.getOne(allotBillEntity.getReceiveUseraId()).getName());
        allotBillEntity.setReceiveUserB(userService.getOne(allotBillEntity.getReceiveUserbId()).getName());
        list.add(allotBillEntity);
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        if (allotBillEntity.getReceiveCheckDetail()!=null){
            for (Integer deviceId: StringSplitUtil.split(allotBillEntity.getReceiveCheckDetail())) {
                libraryEntities.add(deviceLibraryService.getOne(deviceId));
            }
        }
        else {
            for (Integer deviceId: StringSplitUtil.split(allotBillEntity.getAllotCheckDetail())) {
                libraryEntities.add(deviceLibraryService.getOne(deviceId));
            }
        }
        list.add(libraryEntities);
        return ResultUtil.success(list);
    }
}
