package com.tykj.dev.device.packing.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.packing.subject.vo.PackingEditVo;
import com.tykj.dev.device.packing.subject.vo.PackingLibrarySelectVo;
import com.tykj.dev.device.packing.subject.vo.PackingLibraryUpdateVo;
import com.tykj.dev.device.packing.subject.vo.PartSaveVo;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "列装管理模块",description = "列装管理接口")
@AutoDocument
@RequestMapping("/packing")
public class PackingLibraryController {

    @Autowired
    PackingLibraryService packingLibraryService;

    @ApiOperation(value = "列装库退装分页查询",notes = "可以通过这个接口进行列装查询")
    @PostMapping("/retired/summary")
    public ResponseEntity<Page<PackingLibrary>> getInvalidPage(@RequestBody PackingLibrarySelectVo packingLibrarySelectVo){
        Page<PackingLibrary> packingLibraryEntityPage = packingLibraryService.getInvalidPage(packingLibrarySelectVo, packingLibrarySelectVo.getPageable());
        return ResultUtil.success(packingLibraryEntityPage);
    }

    @ApiOperation(value = "列装库列表查询",notes = "可以通过这个接口进行列装查询")
    @PostMapping("/getList")
    public ResponseEntity<List<PackingLibrary>> getList(@RequestBody PackingLibrarySelectVo packingLibrarySelectVo){
        List<PackingLibrary> packingLibraryEntities = packingLibraryService.getList(packingLibrarySelectVo);
        return ResultUtil.success(packingLibraryEntities);
    }


    @ApiOperation(value = "更新列装库",notes = "可以通过这个接口更新列装")
    @PostMapping("/updatePackingLibrary")
    public ResponseEntity<String> updatePackingLibrary(@RequestBody PackingEditVo packingEditVo){
        if (packingEditVo.getUpdateVoList()!=null){
            PackingLibrary packingLibraryEntity = packingLibraryService.getOne(packingEditVo.getPackingId());
            PackingLibraryUpdateVo p = packingEditVo.getUpdateVoList();
            if (p.getApplyType()!=null){
                packingLibraryEntity.setApplyType(p.getApplyType());
            }
            if (p.getCreateUnit()!=null){
                packingLibraryEntity.setCreateUnit(p.getCreateUnit());
            }
            if (p.getFileName()!=null){
                packingLibraryEntity.setFileName(p.getFileName());
            }
            if (p.getFileUrl()!=null){
                packingLibraryEntity.setFileUrl(p.getFileUrl());
            }
            if (p.getImageName()!=null){
                packingLibraryEntity.setImageName(p.getImageName());
            }
            if (p.getImageUrl()!=null){
                packingLibraryEntity.setImageUrl(p.getImageUrl());
            }
            if (p.getInvisibleRange()!=null){
                packingLibraryEntity.setInvisibleRange(p.getInvisibleRange());
            }
            if (p.getMatchingRange()!=null){
                packingLibraryEntity.setMatchingRange(p.getMatchingRange());
            }
            if (p.getModel()!=null){
                packingLibraryEntity.setModel(p.getModel());
            }
            if (p.getName()!=null){
                packingLibraryEntity.setName(p.getName());
            }
            if (p.getNature()!=null){
                packingLibraryEntity.setNature(p.getNature());
            }
            if (p.getPrice()!=null){
                packingLibraryEntity.setPrice(p.getPrice());
            }
            if (p.getProdUnit()!=null){
                packingLibraryEntity.setProdUnit(p.getProdUnit());
            }
            if (p.getSecretLevel()!=null){
                packingLibraryEntity.setSecretLevel(p.getSecretLevel());
            }
            if (p.getStatus()!=null){
                packingLibraryEntity.setStatus(p.getStatus());
            }
            if (p.getType()!=null){
                packingLibraryEntity.setType(p.getType());
            }
            packingLibraryService.update(packingLibraryEntity);
        }
        if (packingEditVo.getPartAddList()!=null){
            for (PartSaveVo p:packingEditVo.getPartAddList()) {
                PackingLibrary packingLibraryEntity = packingLibraryService.getOne(packingEditVo.getPackingId());
                if (packingLibraryEntity.getIsPart()==0&&packingLibraryEntity.getPartParentId()==null){
                    PackingLibrary p2 = new PackingLibrary();
                    BeanUtils.copyProperties(packingLibraryEntity,p2);
                    BeanUtils.copyProperties(p,p2);
                    p2.setId(null);
                    p2.setIsPart(1);
                    p2.setPartParentId(packingLibraryEntity.getId());
                    packingLibraryService.addEntity(p2);
                }
            }
        }
        if (packingEditVo.getPartIdDeleteList()!=null){
            for (Integer id:packingEditVo.getPartIdDeleteList()) {
                if (id>0) {
                    PackingLibrary packingLibraryEntity = packingLibraryService.getOne(id);
                    if (packingLibraryEntity.getIsPart() == 1 && packingLibraryEntity.getPartParentId().equals(packingEditVo.getPackingId())) {
                        packingLibraryEntity.setPartParentId(null);
                        packingLibraryService.update(packingLibraryEntity);
                    }
                }
            }
        }
        return ResultUtil.success("更新成功");
    }

    @ApiOperation(value = "查询存在的型号",notes = "可以通过这个接口查询存在的型号")
    @GetMapping("/selectAllMode")
    public ResponseEntity<List<String>> selectAllMode(){
        return ResultUtil.success(packingLibraryService.getModelList());
    }

    @ApiOperation(value = "查询存在的类型",notes = "可以通过这个接口查询存在的类型")
    @GetMapping("/selectAllType")
    public ResponseEntity<List<Integer>> selectAllType(){
        return ResultUtil.success(packingLibraryService.getTypeList());
    }

    @ApiOperation(value = "查询列装库详情页",notes = "可以通过这个接口查询存在的类型")
    @GetMapping("/serve/detail/{id}")
    public ResponseEntity<List<PackingLibrary>> selectPackingDetail(@PathVariable("id") int id){
        return ResultUtil.success(packingLibraryService.getPackingDetail(id));
    }

    @ApiOperation(value = "查询退装详情页",notes = "可以通过这个接口查询存在的类型")
    @GetMapping("/retired/detail/{id}")
    public ResponseEntity<List<PackingLibrary>> selectInvalidDetail(@PathVariable("id") int id){
        return ResultUtil.success(packingLibraryService.getInvalidDetail(id));
    }
}
