package com.tykj.dev.device.packing.service;

import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.packing.subject.vo.PackingLibrarySelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface PackingLibraryService {

    PackingLibrary addEntity(PackingLibrary packingLibraryEntity);

    Page<PackingLibrary> getPage(PackingLibrarySelectVo packingLibrarySelectVo, Pageable pageable);

    Page<PackingLibrary> getInvalidPage(PackingLibrarySelectVo packingLibrarySelectVo, Pageable pageable);

    List<PackingLibrary> getList(PackingLibrarySelectVo packingLibrarySelectVo);

    List<Integer> getTypeList();

    List<String> getModelList();

    List<PackingLibrary> selectAllPart(Integer id);

    PackingLibrary update(PackingLibrary packingLibraryEntity);

    PackingLibrary getOne(Integer id);

    List<PackingLibrary> getPackingDetail(Integer id);

    List<PackingLibrary> getInvalidDetail(Integer id);

    void delete(Integer id);
}
