package com.tykj.dev.device.packing.subject.vo;

import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("列装存储类")
@Repository
public class PackingLibrarySaveVo {

    @ApiModelProperty(value = "型号",example = "测试型号")
    private String model;

    @ApiModelProperty(value = "名称",example = "测试名称")
    private String name;

    @ApiModelProperty(value = "应用类型",example = "1")
    private Integer applyType;

    @ApiModelProperty(value = "配用范围",example = "1")
    private Integer matchingRange;

    @ApiModelProperty(value = "可见范围",example = "1")
    private Integer invisibleRange;

    @ApiModelProperty(value = "类型",example = "1")
    private Integer type;

    @ApiModelProperty(value = "密级(0:绝密,1:机密,2:秘密)",example = "1")
    private Integer secretLevel;

    @ApiModelProperty(value = "列装性质",example = "1")
    private Integer nature;

    @ApiModelProperty(value = "列装状态",example = "1")
    private Integer status;

    @ApiModelProperty(value = "生产单位",example = "测试型号")
    private String prodUnit;

    @ApiModelProperty(value = "创建单位",example = "测试创建单位")
    private String createUnit;

    @ApiModelProperty(value = "价格",example = "2.000.000")
    private String price;

    @ApiModelProperty(value = "照片名称",example = "没有先填一个空格")
    private String imageName;

    @ApiModelProperty(value = "照片路径",example = "没有先填一个空格")
    private String imageUrl;

    @ApiModelProperty(value = "附件名称",example = "没有先填一个空格")
    private String fileName;

    @ApiModelProperty(value = "附件路径",example = "没有先填一个空格")
    private String fileUrl;

    @ApiModelProperty(value = "B岗用户ID",example = "2")
    private Integer userbId;

    @ApiModelProperty(value = "配件信息列表",example = "")
    private List<PartSaveVo> partList;

    public PackingLibrary toDo(){
        PackingLibrary packingLibraryEntity = new PackingLibrary();
        BeanUtils.copyProperties(this,packingLibraryEntity);
        packingLibraryEntity.setPackingStatus(0);
        packingLibraryEntity.setIsPart(0);
        packingLibraryEntity.setUserbId(this.userbId);
        return packingLibraryEntity;
    }
}
