package com.tykj.dev.device.selfcheck.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.selfcheck.repository.SelfCheckBillDao;
import com.tykj.dev.device.selfcheck.service.SelfCheckBillService;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.device.selfcheck.subject.vo.SelfExaminationSelectVo;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.ResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.Transient;
import java.lang.reflect.Field;
import java.util.Optional;

/**
 * @author dengdiyi
 */
@Service
public class SelfCheckBillServiceImpl implements SelfCheckBillService {

    @Autowired
    private SelfCheckBillDao selfExaminationBillDao;

    @Override
    public SelfCheckBill addEntity(SelfCheckBill selfExaminationBillEntity) {
        return selfExaminationBillDao.save(selfExaminationBillEntity);
    }

    @Override
    public SelfCheckBill update(SelfCheckBill selfExaminationBillEntity) {
        return selfExaminationBillDao.save(selfExaminationBillEntity);
    }

    @Override
    public SelfCheckBill getOne(Integer id) {
        Optional<SelfCheckBill> byId = selfExaminationBillDao.findById(id);
        if (!byId.isPresent()) {
            throw new ApiException(ResultUtil.failed("查询的id不存在"));
        }
        else {
            return byId.get();
        }
    }

    @Override
    public Page<SelfCheckBill> getPage(SelfExaminationSelectVo selfExaminationSelectVo, Pageable pageable) {
        return selfExaminationBillDao.findAll(getSelectSpecification(selfExaminationSelectVo),selfExaminationSelectVo.getPageable());
    }

    @Override
    public void delete(Integer id) {
        selfExaminationBillDao.deleteById(id);
    }

    private Specification<SelfCheckBill> getSelectSpecification(SelfExaminationSelectVo selfExaminationSelectVo){
        PredicateBuilder<SelfCheckBill> predicateBuilder = Specifications.and();
        if (selfExaminationSelectVo!=null) {
            if (selfExaminationSelectVo.getCheckStatus()!=null){
                predicateBuilder.eq("checkStatus",selfExaminationSelectVo.getCheckStatus());
            }
            if (selfExaminationSelectVo.getSelfExaminationUnit()!=null){
                predicateBuilder.eq("checkUnit",selfExaminationSelectVo.getSelfExaminationUnit());
            }
            if (selfExaminationSelectVo.getCheckUserId()!=null){
                predicateBuilder.eq("useraId",selfExaminationSelectVo.getCheckUserId());
            }
            if (selfExaminationSelectVo.getConfirmUserId()!=null){
                predicateBuilder.eq("userbId",selfExaminationSelectVo.getConfirmUserId());
            }
            if (selfExaminationSelectVo.getSelfExaminationCycle()!=null){
                predicateBuilder.eq("cycle",selfExaminationSelectVo.getSelfExaminationCycle());
            }
            if (selfExaminationSelectVo.getCreateUnitId()!=null){
                predicateBuilder.eq("createUnitId",selfExaminationSelectVo.getCreateUnitId());
            }
            if (selfExaminationSelectVo.getCreateUserId()!=null){
                predicateBuilder.eq("createUserId",selfExaminationSelectVo.getCreateUserId());
            }
            if (selfExaminationSelectVo.getContent() != null) {
                Class<SelfCheckBill> selfExaminationBillEntityClass = SelfCheckBill.class;
                Field[] declaredFields = selfExaminationBillEntityClass.getDeclaredFields();
                PredicateBuilder<SelfCheckBill> p = Specifications.or();
                for (Field field : declaredFields) {
                    if (field.getType().equals(String.class)&&field.getAnnotation(Transient.class)==null) {
                        p.like(field.getName(), "%" + selfExaminationSelectVo.getContent() + "%");
                    }
                }
                predicateBuilder.predicate(p.build());
            }
            if (selfExaminationSelectVo.getStartTime() != null) {
                predicateBuilder.gt("createTime", selfExaminationSelectVo.getStartTime());
            }
            if (selfExaminationSelectVo.getEndTime() != null) {
                predicateBuilder.lt("createTime", selfExaminationSelectVo.getEndTime());
            }
        }
        return predicateBuilder.build();
    }
}
