package com.tykj.dev.misc.utils;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ResultMessage
 * @packageName com.example.hello.demo.resultObject
 **/
public class ResultUtil<T> {


    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static <T> ResponseEntity<T> success(T data) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add(HttpHeaders.CONTENT_TYPE, "application/json;charset=UTF-8");
        return new ResponseEntity<>(data,httpHeaders,HttpStatus.OK);
    }

    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static <T> ResponseEntity<T> success(T data,HttpHeaders headers) {
        return new ResponseEntity<>(data,headers,HttpStatus.OK);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<T> failed() {
        return new ResponseEntity<>(HttpStatus.BAD_REQUEST);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<T> failed(T content) {
        return new ResponseEntity<>(content,HttpStatus.BAD_REQUEST);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<T> failed(HttpStatus httpStatus) {
        return new ResponseEntity<>(httpStatus);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<T> failed(HttpStatus httpStatus,T content) {
        return new ResponseEntity<>(content,httpStatus);
    }

    /**
     * 参数验证失败返回结果
     */
    public static <T> ResponseEntity<T> validateFailed(T content) {
        return failed(HttpStatus.BAD_REQUEST,content);
    }


    /**
     * 未登录返回结果
     */
    public static <T> ResponseEntity<T> unauthorized() {
        return failed(HttpStatus.UNAUTHORIZED);
    }

    /**
     * 未授权返回结果
     */
    public static <T> ResponseEntity<T> forbidden() {
        return failed(HttpStatus.FORBIDDEN);

    }



}
