package com.tykj.dev.misc.utils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 * @description 分隔组合字段工具栏
 */
public class StringSplitUtil {

    /**
     * @param s 需要分隔的字符串
     * @return 一串id的List
     */
    public static List<Integer> split(String s) {
        List<Integer> list = new ArrayList<>();
        //分隔开始的s标识符
        if (s.charAt(0)=='s') {
            s = s.substring(1);
        }
        //按分隔符x分隔
        String[] strings = s.split("x");
        //遍历获取id\
        if (strings.length>0) {
            for (String str : strings) {
                if (str.length() >= 2 && "1".equals(str.substring(str.length() - 1))) {
                    list.add(Integer.parseInt(str.substring(0, str.length() - 1)));
                }
            }
        }
        return list;
    }

    public static List<Integer> userIdSplit(String s){
        List<Integer> list = new ArrayList<>();
        if (s!=null) {
            //按分隔符x分隔
            String[] strings = s.split("x");
            //遍历获取id
            if (strings.length != 0) {
                for (String str : strings) {
                    if (str.length() > 0) {
                        list.add(Integer.valueOf(str));
                    }
                }
            }
        }
        return list;
    }

    public static String idListToString(List<Integer> list){
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        if (list!=null&&list.size()>0) {
            list.forEach(integer -> {
                stringBuffer.append(integer);
                stringBuffer.append("x");
            });
        }
        return stringBuffer.toString();
    }
}
