package com.tykj.dev.device.confirmcheck.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * CheckDeviceStatVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/15 at 7:18 下午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@Builder
@Slf4j
public class CheckDeviceStatVo {

    /**
     * 装备型号
     */
    private String deviceModel;

    /**
     * 装备名称
     */
    private String deviceName;

    /**
     * 装备总数
     */
    private int deviceCount;


    /**
     * 核查该型号装备的各地区统计情况
     */
    private List<CheckAreaStatVo> areaStatList;

    /**
     * other的model一定要与本deviceModel相同
     */
    public void add(CheckDeviceStatVo other) {
        if (!deviceModel.equals(other.getDeviceModel())) {
            log.warn("[核查] 合并统计的数据发现装备不统一的情况");
            return;
        }

        deviceCount += other.getDeviceCount();
        for (CheckAreaStatVo otherArea : other.getAreaStatList()) {
            if (deviceModel.equals(other.getDeviceModel())) {
                for (CheckAreaStatVo statVo : areaStatList) {
                    if (statVo.getAreaName().equals(otherArea.getAreaName())) {
                        statVo.setAreaName(otherArea.getAreaName());
                        statVo.setAreaStatId(otherArea.getAreaStatId());
                        statVo.setAreaDetailId(otherArea.getAreaDetailId());
                        statVo.setActualCount(statVo.getActualCount() + otherArea.getActualCount());
                        statVo.setSupposeCount(statVo.getSupposeCount() + otherArea.getSupposeCount());
                        statVo.setComProgress(otherArea.getComProgress());
                        statVo.setComSituation(otherArea.getComSituation());
                    }
                }
            }
        }
    }

}
