package com.tykj.dev.device.matching.subject.vo;

import com.tykj.dev.device.matching.subject.domin.MatchingDeviceLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配套设备存储类")
public class MatchingDeviceSaveVo {

    @ApiModelProperty(value = "设备类型")
    private String type;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "创建单位")
    private String createUnit;

    @ApiModelProperty(value = "设备序列号")
    private String seqNumber;

    @ApiModelProperty(value = "rfid表面号")
    private String rfidSurfaceId;

    @ApiModelProperty(value = "rfid卡号")
    private String rfidCardId;

    public MatchingDeviceLibrary toDo(){
        MatchingDeviceLibrary matchingDeviceLibraryEntity = new MatchingDeviceLibrary();
        BeanUtils.copyProperties(this,matchingDeviceLibraryEntity);
        matchingDeviceLibraryEntity.setLifeStatus(0);
        matchingDeviceLibraryEntity.setDeviceId(0);
        return matchingDeviceLibraryEntity;
    }
}
