/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.NativeUsbAdapter;
import com.zebra.sdk.comm.internal.UsbConnectionI;
import com.zebra.sdk.comm.internal.UsbUtils;
import com.zebra.sdk.comm.internal.UsbWindowsUtils;
import com.zebra.sdk.util.internal.StringUtilities;
import java.util.Map;

public class UsbConnectionWindows
extends ConnectionA
implements UsbConnectionI {
    private final NativeUsbAdapter nativeUsbAdapter = new NativeUsbAdapter();
    private int nativeHandle = 0;
    protected String symbolicName = "";
    private Map<String, String> connectionAttributes;

    public UsbConnectionWindows(String string) throws ConnectionException {
        this.symbolicName = string;
    }

    @Override
    public Map<String, String> loadDeviceMap() throws ConnectionException {
        this.connectionAttributes = UsbWindowsUtils.loadDeviceIdMap(this.symbolicName);
        return this.connectionAttributes;
    }

    @Override
    public void open() throws ConnectionException {
        if (this.nativeUsbAdapter == null) {
            throw new ConnectionException("Failed to instantiate printer ");
        }
        if (!NativeUsbAdapter.isDriverLoaded) {
            throw new ConnectionException("The native code dll is not loaded.");
        }
        if (this.isConnected) {
            return;
        }
        this.nativeHandle = this.nativeUsbAdapter.Open(this.symbolicName);
        if (this.nativeHandle == 0) {
            throw new ConnectionException("Could not connect to device: " + this.symbolicName);
        }
        if (this.maxTimeoutForRead > 0) {
            this.nativeUsbAdapter.SetMaxReadTimeout(this.nativeHandle, this.maxTimeoutForRead);
        }
        this.isConnected = true;
    }

    @Override
    public void close() throws ConnectionException {
        if (this.nativeUsbAdapter == null) {
            throw new ConnectionException("Failed to instantiate printer ");
        }
        if (!NativeUsbAdapter.isDriverLoaded) {
            throw new ConnectionException("The native code dll is not loaded.");
        }
        this.nativeUsbAdapter.Close(this.nativeHandle);
        this.nativeHandle = 0;
        this.isConnected = false;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        if (this.nativeUsbAdapter == null) {
            throw new ConnectionException("Failed to instantiate printer ");
        }
        if (!NativeUsbAdapter.isDriverLoaded) {
            throw new ConnectionException("The native code dll is not loaded.");
        }
        if (this.nativeHandle == 0) {
            throw new ConnectionException("The connection is not open");
        }
        int n3 = 0;
        if (byArray != null) {
            try {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                n3 = this.nativeUsbAdapter.Write(this.nativeHandle, byArray2, n2);
            }
            catch (Exception exception) {
                throw new ConnectionException(exception.getLocalizedMessage(), exception);
            }
            if (n3 <= 0) {
                throw new ConnectionException("Error writing to connection: " + this.symbolicName);
            }
        }
    }

    @Override
    public byte[] readFromPrinter() throws ConnectionException {
        int n = 1024;
        return this.nativeRead(n);
    }

    @Override
    public byte[] nativeRead(int n) throws ConnectionException {
        int n2 = 0;
        byte[] byArray = new byte[n];
        try {
            n2 = this.nativeUsbAdapter.Read(this.nativeHandle, byArray, n);
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getLocalizedMessage(), exception);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    @Override
    public String getSimpleConnectionName() {
        return null;
    }

    @Override
    public void setMaxTimeoutForRead(int n) {
        this.maxTimeoutForRead = n;
        if (this.nativeHandle != 0) {
            this.nativeUsbAdapter.SetMaxReadTimeout(this.nativeHandle, n);
        }
    }

    @Override
    public Map<String, String> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerialNumber() {
        String string = this.connectionAttributes.get("SERIAL_NUMBER");
        if (!UsbUtils.isCardPrinter(this.connectionAttributes)) {
            try {
                this.open();
                this.write("! U1 getvar \"device.unique_id\"\r\n".getBytes());
                String string2 = new String(this.nativeRead(1024));
                if (string2 != null && !string2.isEmpty()) {
                    string = StringUtilities.stripQuotes(string2);
                    this.connectionAttributes.put("SERIAL_NUMBER", string);
                }
            }
            catch (ConnectionException connectionException) {
            }
            finally {
                try {
                    this.close();
                }
                catch (ConnectionException connectionException) {}
            }
        }
        return string;
    }
}

