/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.internal.ZebraSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ZebraNetworkSocket
implements ZebraSocket {
    private Socket socket;
    private InetSocketAddress inetSocketAddress;
    private final int MAX_TIMEOUT = 15000;

    public ZebraNetworkSocket(String string, int n) throws UnknownHostException {
        Socket socket;
        this.inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string), n);
        this.socket = socket = new Socket();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void connect() throws IOException {
        if (this.socket.isConnected()) {
            this.socket.close();
        }
        this.socket.connect(this.inetSocketAddress, 15000);
    }

    @Override
    public void setReadTimeout(int n) throws IOException {
        this.socket.setSoTimeout(n);
    }
}

