/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.graphics.internal;

import com.zebra.sdk.graphics.internal.DitheredImageProvider;
import com.zebra.sdk.graphics.internal.Ditherer;
import com.zebra.sdk.graphics.internal.NaughtyBitOutputStream;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.util.internal.ReflectionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DitheringStream
extends InputStream {
    private ZebraImageInternal image = null;
    private int[] headerInfo;
    private int headerIndex = 0;
    private ByteArrayInputStream tempDitheredImageBuffer;

    public DitheringStream(InputStream inputStream) throws IOException {
        this((ZebraImageInternal)ReflectionUtil.invokeZebraImageFactory_getImage(inputStream));
    }

    public DitheringStream(ZebraImageInternal zebraImageInternal) throws IOException {
        this.image = zebraImageInternal;
        this.processImage();
    }

    private void processImage() throws IOException {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        this.headerInfo = Ditherer.getZebraSpecificPngHeader(n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DitheredImageProvider.getDitheredImage(this.image, new NaughtyBitOutputStream(byteArrayOutputStream));
        this.tempDitheredImageBuffer = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public int read() {
        int n = -1;
        n = this.headerIndex < this.headerInfo.length ? this.headerInfo[this.headerIndex++] : this.tempDitheredImageBuffer.read();
        return n;
    }
}

