package com.tykj.dev.blockcha.subject.service;



import com.tykj.dev.blockcha.subject.entity.*;

import java.util.Map;

/**
 * 对接白鸟区块链接口实现
 *
 * @author LJJ cnljj1995@gmail.com
 * on 2020-08-13
 */
public interface BlockChainUtil {

    /**
     * 获取区块链状态
     *
     * @return BS
     */
    BcStatus getStatus();

    /**
     * 业务类型码注册
     *
     * @param subName 业务名称，可以是中英文
     * @return br
     */
    BcRegister subRegister(String subName);

    /**
     * 文本上链
     *
     * @param subCode 业务代码编号
     * @param content 文本 200k以内
     * @return bt
     */
    BcText sendText(Integer subCode, String content);

    /**
     * hash 上链
     *
     * @param subCode 业务代码编号
     * @param content 内容哈希，256bits hex编码。 方法可参考本模块HexUtil
     * @return bh
     */
    BcHash sendHash(Integer subCode, String content);

    /**
     * 记录查询
     *
     * @param recordId 记录id
     * @return fr
     */
    BcRecord fetchRecord(String recordId);

    /**
     * 记录批量查询
     *
     * @param map k: "type", v: String,
     *            required：false, remark: 记录类型，text/hash(文本或哈希)， 省略包含两者
     *
     *            k: "subCode", v: Integer,
     *            required：false, remark: 业务类型码，用于区分不同业务，默认全部
     *
     *            k: "fromEarliest", v: Integer,
     *            required：false, remark: 是否从最早的数据开始查询，默认从最新数据开始
     *
     *            k: "limit", v: Integer,
     *            required：false, remark: 获取记录数，默认20，上限200
     *
     *            k: "cursor", v: String,
     *            required：false, remark: 游标，用于标识数据读取位置，首次留空， 查询下一页数据传上一次返回的值
     * @return bc
     */
    BcHistory fetchHistory(Map<String, Object> map);

}
