package com.tykj.dev.blockcha.subject.service.impl;

import com.tykj.dev.blockcha.conf.BcUrl;
import com.tykj.dev.blockcha.subject.entity.*;
import com.tykj.dev.blockcha.subject.service.BlockChainUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;

/**
 * 步骤：
 * 1.构建请求参数
 * 2.通过rest_template获取数据
 *
 * @author LJJ cnljj1995@gmail.com
 * on 2020-08-13
 */
@Slf4j
@Component
public class BlockChainUtilImpl implements BlockChainUtil {

    private final static String SECRET_KEY = "aLTEmMyIfAWzVCIy8EKI0uGFThrR20dR12C62ENZ16RAX5TNTLUC4CCP";
    private final static String SECRET_ID = "tLNj025SOWTWv56ORlRdGA";
    private final static String BLOCK_CHAIN_URL = "http://120.55.94.123";


    @Override
    public BcStatus getStatus() {

        SortedMap<Object, Object> request = getRequest();
        request.put("apiSignature", ApiSignatureUtil.getApiSignature(request, SECRET_KEY));

        return new RestTemplate().postForObject(
                BLOCK_CHAIN_URL + BcUrl.GET_STATUS,
                request,
                BcStatus.class);
    }

    @Override
    public BcRegister subRegister(String subName) {

        SortedMap<Object, Object> request = getRequest();
        request.put("subName", subName);
        request.put("apiSignature", ApiSignatureUtil.getApiSignature(request, SECRET_KEY));

        return new RestTemplate().postForObject(
                BLOCK_CHAIN_URL + BcUrl.SUB_CODE_REGISTER,
                request,
                BcRegister.class
        );
    }

    @Override
    public BcText sendText(Integer subCode, String content) {

        SortedMap<Object, Object> request = getRequest();
        request.put("content", content);
        request.put("subCode", subCode);
        request.put("apiSignature", ApiSignatureUtil.getApiSignature(request, SECRET_KEY));

        return new RestTemplate().postForObject(
                BLOCK_CHAIN_URL + BcUrl.SEND_TEXT,
                request,
                BcText.class
        );
    }

    @Override
    public BcHash sendHash(Integer subCode, String content) {
        SortedMap<Object, Object> request = getRequest();
        request.put("content", content);
        request.put("subCode", subCode);
        request.put("apiSignature", ApiSignatureUtil.getApiSignature(request, SECRET_KEY));

        return new RestTemplate().postForObject(
                BLOCK_CHAIN_URL + BcUrl.SEND_HASH,
                request,
                BcHash.class
        );
    }

    @Override
    public BcRecord fetchRecord(String recordId) {
        SortedMap<Object, Object> request = getRequest();
        request.put("recordID", recordId);
        request.put("apiSignature", ApiSignatureUtil.getApiSignature(request, SECRET_KEY));

        return new RestTemplate().postForObject(
                BLOCK_CHAIN_URL + BcUrl.FETCH_RECORD,
                request,
                BcRecord.class
        );
    }

    @Override
    public BcHistory fetchHistory(Map<String, Object> map) {

        SortedMap<Object, Object> request = getRequest();
        map.forEach(request::put);
        request.put("apiSignature", ApiSignatureUtil.getApiSignature(request, SECRET_KEY));
        log.info("{}", request);
        return new RestTemplate().postForObject(
                BLOCK_CHAIN_URL + BcUrl.FETCH_HISTORY,
                request,
                BcHistory.class
        );
    }

    /**
     * 存储通用参数
     *
     * @return request
     */
    private SortedMap<Object, Object> getRequest() {
        long timestamp = System.currentTimeMillis() / 1000;
        String nonce = UUID.randomUUID().toString().trim().replaceAll("-", "");
        SortedMap<Object, Object> request = new TreeMap<Object, Object>();
        request.put("timestamp", timestamp);
        request.put("nonce", nonce);
        request.put("secretID", SECRET_ID);
        return request;
    }

}
