package com.tykj.dev.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName MyWebMvcConfig.java
 * @Description TODO
 * @createTime 2020年08月09日 17:28:00
 */
@Configuration
public class MyWebMvcConfig implements WebMvcConfigurer {
    @Value("${file.path}")
    private String path;
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        // 将/static/**访问映射到classpath:/mystatic/
        registry.addResourceHandler("/file/**").addResourceLocations("file:"+path);
    }
}
