package com.tykj.dev.device.confirmcheck.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * CheckAreaStatVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/15 at 7:20 下午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class CheckAreaStatVo {

    /**
     * 地区名
     */
    private String areaName;

    /**
     * 实查数量
     */
    private int actualCount;

    /**
     * 应查数量
     */
    private int supposeCount;

    /**
     * 完成进度 0-待办 ， 1-进行中， 2-已完成
     */
    private int comProgress;

    /**
     * 完成情况 0-无误 1-有异常
     */
    private int comSituation;

    /**
     * 该地区对应的统计账单id
     */
    private int areaStatId;

    /**
     * 该地区对应的详情账单id
     */
    private int areaDetailId;
}
