package com.tykj.dev.device.matching.service.impl;

import com.tykj.dev.device.matching.repository.MatchingDeviceBillDao;
import com.tykj.dev.device.matching.service.MatchingDeviceBillService;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceBill;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author dengdiyi
 */
@Service
public class MatchingDeviceBillServiceImpl implements MatchingDeviceBillService {

    @Autowired
    private MatchingDeviceBillDao matchingDeviceBillDao;

    @Override
    public MatchingDeviceBill addEntity(MatchingDeviceBill matchingDeviceBillEntity) {
        return matchingDeviceBillDao.save(matchingDeviceBillEntity);
    }

    @Override
    public MatchingDeviceBill getOne(Integer id) {
        Optional<MatchingDeviceBill> deviceBillEntity = matchingDeviceBillDao.findById(id);
        return deviceBillEntity.orElse(null);
    }

    @Override
    public MatchingDeviceBill update(MatchingDeviceBill matchingDeviceBillEntity) {
        return matchingDeviceBillDao.save(matchingDeviceBillEntity);
    }
}
