package com.tykj.dev.device.matching.subject.vo;

import com.tykj.dev.device.matching.subject.domin.MatchingDeviceBill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配套设备账单存储类")
public class MatchingDeviceBillSaveVo {

    @ApiModelProperty(value = "确认单附件名")
    private String fileName;

    @ApiModelProperty(value = "确认单附件url")
    private String fileUrl;

    @ApiModelProperty(value = "发起人id")
    private Integer useraId;

    @ApiModelProperty(value = "审核人id")
    private Integer userbId;

    @ApiModelProperty(value = "配套设备列表")
    private List<MatchingDeviceSaveVo> matchingDeviceSaveVoList;

    public MatchingDeviceBill toDo(){
        MatchingDeviceBill matchingDeviceBillEntity = new MatchingDeviceBill();
        BeanUtils.copyProperties(this,matchingDeviceBillEntity);
        matchingDeviceBillEntity.setBillStatus(0);
        matchingDeviceBillEntity.setDeviceDetail("x");
        return matchingDeviceBillEntity;
    }
}
