package com.tykj.dev.device.packing.service;

import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.packing.subject.vo.PackingLibrarySelectVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface PackingLibraryService {

    /**
     * @param packingLibraryEntity
     * 添加列装
     */
    PackingLibrary addEntity(PackingLibrary packingLibraryEntity);

    /**
     * @param packingLibrarySelectVo 列装查询vo
     * @param pageable
     * 获取列装库分页
     */
    Page<PackingLibrary> getPage(PackingLibrarySelectVo packingLibrarySelectVo, Pageable pageable);

    /**
     * @param packingLibrarySelectVo 列装查询vo
     * @param pageable
     * 获取列装库退装分页
     */
    Page<PackingLibrary> getInvalidPage(PackingLibrarySelectVo packingLibrarySelectVo, Pageable pageable);

    /**
     * @param packingLibrarySelectVo 列装查询vo
     * 获取父子结构列装列表
     */
    List<PackingLibrary> getList(PackingLibrarySelectVo packingLibrarySelectVo);

    /**
     * 获取所有存在的类型列表
     */
    List<Integer> getTypeList();

    /**
     * 获取所有的型号列表
     */
    List<String> getModelList();

    /**
     * @param id 列装库装备主键id
     * 获取某个列装装备的所有配件
     */
    List<PackingLibrary> selectAllPart(Integer id);

    /**
     * @param packingLibraryEntity
     * 更新列装信息
     */
    PackingLibrary update(PackingLibrary packingLibraryEntity);

    /**
     * @param id 列装库主键Id
     * 根据id获取列装
     */
    PackingLibrary getOne(Integer id);

    /**
     * @param id 列装库装备主键id
     * 通过id查询列装详情(装备+配件)
     */
    List<PackingLibrary> getPackingDetail(Integer id);

    /**
     * @param id 列装库装备主键id
     * 通过id查询退装详情(装备+配件)
     */
    List<PackingLibrary> getInvalidDetail(Integer id);

    /**
     * @param id 列装主键id
     * 通过id逻辑删除列装
     */
    void delete(Integer id);
}
