package com.tykj.dev.device.packing.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for packing_library
 * 列装库
*/
@Data
@Entity
@ApiModel("列装库")
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update packing_library set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class PackingLibrary {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(value = "主键id")
	private Integer id;
	/**
	* 经办人省A岗id
	*/
	@ApiModelProperty(value = "经办人省A岗id")
	private Integer useraId;
	/**
	* 审核人省B岗id
	*/
	@ApiModelProperty(value = "审核人省B岗id")
	private Integer userbId;
	/**
	 * 是不是配件(0:不是，1:是)
	 */
	@ApiModelProperty(value = "是不是配件(0:不是，1:是)")
	private Integer isPart;
	/**
	 * 配件对应装备列装id
	 */
	@ApiModelProperty(value = "配件对应装备列装id")
	private Integer partParentId;
	/**
	* 列装状态(0:待审核,1:审核失败,2:审核成功待确认,3:已列装,4:已退装)
	*/
	@ApiModelProperty(value = "列装状态(0:待审核,1:审核失败,2:审核成功待确认,3:已列装,4:已退装)")
	private Integer packingStatus;
	/**
	* 型号
	*/
	@ApiModelProperty(value = "型号")
	private String model;
	/**
	 * 密级
	 */
	@ApiModelProperty(value = "密级")
	private Integer secretLevel;
	/**
	* 名称
	*/
	@ApiModelProperty(value = "名称")
	private String name;
	/**
	* 应用类型
	*/
	@ApiModelProperty(value = "应用类型")
	private Integer applyType;
	/**
	* 配用范围
	*/
	@ApiModelProperty(value = "配用范围")
	private Integer matchingRange;
	/**
	* 可见范围
	*/
	@ApiModelProperty(value = "可见范围")
	private Integer invisibleRange;
	/**
	* 类型
	*/
	@ApiModelProperty(value = "类型")
	private Integer type;
	/**
	* 列装性质
	*/
	@ApiModelProperty(value = "列装性质")
	private Integer nature;
	/**
	* 列装状态
	*/
	@ApiModelProperty(value = "列装状态")
	private Integer status;
	/**
	* 生产单位
	*/
	@ApiModelProperty(value = "生产单位")
	private String prodUnit;
	/**
	* 创建单位
	*/
	@ApiModelProperty(value = "创建单位")
	private String createUnit;
	/**
	* 价格
	*/
	@ApiModelProperty(value = "价格")
	private String price;
	/**
	* 图片名称
	*/
	@ApiModelProperty(value = "图片名称")
	private String imageName;
	/**
	* 图片url地址
	*/
	@ApiModelProperty(value = "图片url地址")
	private String imageUrl;
	/**
	* 附件名称
	*/
	@ApiModelProperty(value = "附件名称")
	private String fileName;
	/**
	* 附件url地址
	*/
	@ApiModelProperty(value = "附件url地址")
	private String fileUrl;
	/**
	* 退装时间
	*/
	@ApiModelProperty(value = "退装时间")
	private java.sql.Timestamp exitTime;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(name = "创建时间")
	private Date createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	@Transient
	List<PackingLibrary> childs = new ArrayList<>();

	/**
	 * 装备和配件对应关系 相同的是一套设备
	 */
	@Transient
	private Integer corresponding;

	public void addChildNode(PackingLibrary packingLibraryEntity) {
		childs.add(packingLibraryEntity);
	}

	@ApiModelProperty(value = "经办人省A岗")
	@Transient
	private String userA;

	@ApiModelProperty(value = "审核人省B岗")
	@Transient
	private String userB;

	@ApiModelProperty(value = "申请数量")
	@Transient
	private Integer applyNum;
}
