package com.tykj.dev.device.repair.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.repair.repository.RepairSendBillDao;
import com.tykj.dev.device.repair.service.RepairSendBillService;
import com.tykj.dev.device.repair.subject.domin.RepairSendBill;
import com.tykj.dev.device.repair.subject.vo.RepairBillSelectVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.Transient;
import java.lang.reflect.Field;
import java.util.Optional;

/**
 * @author dengdiyi
 */
@Service
public class RepairSendBillServiceImpl implements RepairSendBillService {

    @Autowired
    private UserPublicService userService;

    @Autowired
    private RepairSendBillDao deviceRepairSendBillDao;

    @Override
    public RepairSendBill addEntity(RepairSendBill deviceRepairSendBillEntity) {
        return deviceRepairSendBillDao.save(deviceRepairSendBillEntity);
    }

    @Override
    public Page<RepairSendBill> getPage(RepairBillSelectVo deviceRepairBillSelectVo, Pageable pageable) {
        Page<RepairSendBill> page = deviceRepairSendBillDao.findAll(getSelectSpecification(deviceRepairBillSelectVo),deviceRepairBillSelectVo.getPageable());
        for (RepairSendBill d:page.getContent()) {
            d.setStartUserA(userService.getOne(d.getStartUseraId()).getName());
            d.setStartUserB(userService.getOne(d.getStartUserbId()).getName());
            d.setRepairUserA(userService.getOne(d.getRepairUseraId()).getName());
            d.setRepairUserB(userService.getOne(d.getRepairUserbId()).getName());
        }
        return page;
    }

    @Override
    public RepairSendBill getOne(Integer id) {
        Optional<RepairSendBill> resultEntity = deviceRepairSendBillDao.findById(id);
        return resultEntity.orElse(null);
    }

    @Override
    public RepairSendBill update(RepairSendBill deviceRepairSendBillEntity) {
        return deviceRepairSendBillDao.save(deviceRepairSendBillEntity);
    }

    @Override
    public void delete(Integer id) {
        deviceRepairSendBillDao.deleteById(id);
    }

    private Specification<RepairSendBill> getSelectSpecification(RepairBillSelectVo deviceRepairBillSelectVo){
        PredicateBuilder<RepairSendBill> predicateBuilder = Specifications.and();
        if (deviceRepairBillSelectVo!=null) {
            if (deviceRepairBillSelectVo.getRepairUseraId()!=null){
                predicateBuilder.eq("repairUseraId",deviceRepairBillSelectVo.getRepairUseraId());
            }
            if (deviceRepairBillSelectVo.getReceiveUnit()!=null){
                predicateBuilder.eq("receiveUnit",deviceRepairBillSelectVo.getReceiveUnit());
            }
            if (deviceRepairBillSelectVo.getRepairUserbId()!=null){
                predicateBuilder.eq("repairUserbId",deviceRepairBillSelectVo.getRepairUserbId());
            }
            if (deviceRepairBillSelectVo.getStartUseraId()!=null){
                predicateBuilder.eq("startUseraId",deviceRepairBillSelectVo.getStartUseraId());
            }
            if (deviceRepairBillSelectVo.getStartUserbId()!=null){
                predicateBuilder.eq("startUserbId",deviceRepairBillSelectVo.getStartUserbId());
            }
            if (deviceRepairBillSelectVo.getContent() != null) {
                Class<RepairSendBill> deviceRepairBillEntityClass = RepairSendBill.class;
                Field[] declaredFields = deviceRepairBillEntityClass.getDeclaredFields();
                PredicateBuilder<RepairSendBill> p = Specifications.or();
                for (Field field : declaredFields) {
                    if (field.getType().equals(String.class)&&field.getAnnotation(Transient.class)==null) {
                        p.like(field.getName(), "%" + deviceRepairBillSelectVo.getContent() + "%");
                    }
                }
                predicateBuilder.predicate(p.build());
            }
            if (deviceRepairBillSelectVo.getStartTime() != null) {
                predicateBuilder.gt("createTime", deviceRepairBillSelectVo.getStartTime());
            }
            if (deviceRepairBillSelectVo.getEndTime() != null) {
                predicateBuilder.lt("updateTime", deviceRepairBillSelectVo.getEndTime());
            }
        }
        return predicateBuilder.build();
    }
}
