import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceVo.java
 * @Description TODO
 * @createTime 2020年08月19日 16:39:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "报废装备对象", description = "报废装备对象")
public class DeviceVo {

    @ApiModelProperty(value = "型号",example = "bmxx")
    public String model;

    @ApiModelProperty(value = "类别",example = "1")
    public Integer type;

    @ApiModelProperty(value = "部件",example = "1")
    public Integer parts;

    @ApiModelProperty(value = "密级",example = "1")
    public String secretLevel;

    @ApiModelProperty(value = "可见范围(应用领域)",example = "1")
    public Integer invisibleRange;

    @ApiModelProperty(value ="备注",example = "msg")
    public String msg;

    /**
     * 装备序列号
     */
    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;
    /**
     * 生产序列号
     */
    @ApiModelProperty(value = "生产序列号")
    private String prodNumber;

    public static DeviceVo toDo(){
        return new DeviceVo("MB-01",1,1,"机密",1,"---","MB0125576p101","MB012374123");
    }

}
