package com.tykj.dev.device.selfcheck.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.selfcheck.repository.SelfCheckBillDao;
import com.tykj.dev.device.selfcheck.service.SelfCheckBillService;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.device.selfcheck.subject.vo.SelfCheckSelectVo;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.ResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.Transient;
import java.lang.reflect.Field;
import java.util.Optional;

/**
 * @author dengdiyi
 */
@Service
public class SelfCheckBillServiceImpl implements SelfCheckBillService {

    @Autowired
    private SelfCheckBillDao selfExaminationBillDao;

    @Override
    public SelfCheckBill addEntity(SelfCheckBill selfExaminationBillEntity) {
        return selfExaminationBillDao.save(selfExaminationBillEntity);
    }

    @Override
    public SelfCheckBill update(SelfCheckBill selfExaminationBillEntity) {
        return selfExaminationBillDao.save(selfExaminationBillEntity);
    }

    @Override
    public SelfCheckBill getOne(Integer id) {
        Optional<SelfCheckBill> byId = selfExaminationBillDao.findById(id);
        if (!byId.isPresent()) {
            throw new ApiException(ResultUtil.failed("查询的id不存在"));
        }
        else {
            return byId.get();
        }
    }

    @Override
    public Page<SelfCheckBill> getPage(SelfCheckSelectVo selfCheckSelectVo, Pageable pageable) {
        return selfExaminationBillDao.findAll(getSelectSpecification(selfCheckSelectVo), selfCheckSelectVo.getPageable());
    }

    @Override
    public void delete(Integer id) {
        selfExaminationBillDao.deleteById(id);
    }

    private Specification<SelfCheckBill> getSelectSpecification(SelfCheckSelectVo selfCheckSelectVo){
        PredicateBuilder<SelfCheckBill> predicateBuilder = Specifications.and();
        if (selfCheckSelectVo !=null) {
            if (selfCheckSelectVo.getCheckStatus()!=null){
                predicateBuilder.eq("checkStatus", selfCheckSelectVo.getCheckStatus());
            }
            if (selfCheckSelectVo.getSelfExaminationUnit()!=null){
                predicateBuilder.eq("checkUnit", selfCheckSelectVo.getSelfExaminationUnit());
            }
            if (selfCheckSelectVo.getCheckUserId()!=null){
                predicateBuilder.eq("useraId", selfCheckSelectVo.getCheckUserId());
            }
            if (selfCheckSelectVo.getConfirmUserId()!=null){
                predicateBuilder.eq("userbId", selfCheckSelectVo.getConfirmUserId());
            }
            if (selfCheckSelectVo.getSelfExaminationCycle()!=null){
                predicateBuilder.eq("cycle", selfCheckSelectVo.getSelfExaminationCycle());
            }
            if (selfCheckSelectVo.getCreateUnitId()!=null){
                predicateBuilder.eq("createUnitId", selfCheckSelectVo.getCreateUnitId());
            }
            if (selfCheckSelectVo.getCreateUserId()!=null){
                predicateBuilder.eq("createUserId", selfCheckSelectVo.getCreateUserId());
            }
            if (selfCheckSelectVo.getContent() != null) {
                Class<SelfCheckBill> selfExaminationBillEntityClass = SelfCheckBill.class;
                Field[] declaredFields = selfExaminationBillEntityClass.getDeclaredFields();
                PredicateBuilder<SelfCheckBill> p = Specifications.or();
                for (Field field : declaredFields) {
                    if (field.getType().equals(String.class)&&field.getAnnotation(Transient.class)==null) {
                        p.like(field.getName(), "%" + selfCheckSelectVo.getContent() + "%");
                    }
                }
                predicateBuilder.predicate(p.build());
            }
            if (selfCheckSelectVo.getStartTime() != null) {
                predicateBuilder.gt("createTime", selfCheckSelectVo.getStartTime());
            }
            if (selfCheckSelectVo.getEndTime() != null) {
                predicateBuilder.lt("createTime", selfCheckSelectVo.getEndTime());
            }
        }
        return predicateBuilder.build();
    }
}
