package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.user.subject.entity.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName InTrainVo.java
 * @Description TODO
 * @createTime 2020年08月17日 23:45:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "培训返回的对象", description = "培训的对象")
public class InTrainVo {
    /**
     * 培训id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "培训id")
    private Integer trainId;

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @ApiModelProperty(value = "报名截止时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date trainTime;

    /**
     *  发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String  originatorName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;

    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private Integer  speakerUserId;

    /**
     * 培训资料
     */
    @ApiModelProperty(value = "培训资料")
    private String trainData;

    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;

//    /**
//     * 参会人员（必须参会）
//     */
//    @ApiModelProperty(value = "参会人员id 多个使用人员id+x+id+x")
//    private String joinUserId;

    /**
     * 报名人员 暂时user代替
     */
    @ApiModelProperty(value = "参会人员id 多个使用人员id+x+id+x")
    private List<User> signUp;

    /**
     * 培训结果
     */
    private List<GradeEntry> trainingResults;

    /**
     * 培训状态 1报名中  2待培训  3培训中
     */
    @ApiModelProperty(value = "培训状态")
    private Integer trainStatus;

    /**
     * 发证状态
     */
    @ApiModelProperty(value = "发证状态")
    private Integer isCertificate;
}
