package com.tykj.dev.device.user.util;

import com.tykj.dev.device.user.subject.entity.SecurityUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * 用户实体相关工具类
 *
 * @author HuangXiahao
 * @version V1.0
 * @class AuthenticationUtils
 * @packageName com.example.personnelmanager.common.utils
 * @data 2020/5/14
 **/
@Slf4j
public class AuthenticationUtils {

    public static String ANONYMOUS_USER_STRING = "anonymousUser";
    /***
     * 获取当前登录用户
     *
     * @Return : com.example.personnelmanager.entity.UserDetail
    */
    public static SecurityUser getAuthentication(){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication!=null){
            if (ANONYMOUS_USER_STRING.equals(authentication.getPrincipal())){
                log.info("当前无登录用户");
            }
            return (SecurityUser) authentication.getPrincipal();
        }else {
            log.info("当前无登录用户");
            return null;
        }

    }

}
