package com.tykj.dev.device.library.service;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.task.subject.vo.BussinessLogVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface DeviceLibraryService {
    DeviceLibrary addEntity(DeviceLibrary deviceLibraryEntity);

    List<DeviceLibrary> addEntityList(List<DeviceLibrary> list);

    Page<DeviceLibrary> getPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    Page<DeviceLibrary> getTagPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    List<DeviceLibrary> getAllotPage(DeviceLibrarySelectVo deviceLibrarySelectVo);

    Page<DeviceLibrary> getCoreDevicePage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

//    Page<DeviceLibrary> getDeviceStatisticsPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    List<String> getAllName();

    List<BussinessLogVo> getDeviceLog(Integer id);

    List<DeviceLibrary> getList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    List<DeviceLibrary> getAllList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    List<DeviceLibrary> getCheckList();

    List<DeviceLibrary> getAllotList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    List<DeviceLibrary> getListByBillId(Integer id);

    DeviceLibrary update(DeviceLibrary deviceLibraryEntity);

    DeviceLibrary getOne(Integer id);

    void delete(Integer id);

    List<DeviceLibrary> getListWithoutParent(DeviceLibrarySelectVo deviceLibrarySelectVo);

    List<String> getAllUnit();
}
