package com.tykj.dev.device.library.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

/**
 * entity class for device_library
 * 装备库
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_library set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备库")
public class DeviceLibrary {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(name = "主键id")
    private Integer id;
    /**
     * 入库单id
     */
    @ApiModelProperty(value = "入库单id")
    private Integer storageBillId;
    /**
     * 列装id
     */
    @ApiModelProperty(value = "列装id")
    private Integer packingId;
    /**
     * 是不是配件(0:不是，1:是)
     */
    @ApiModelProperty(value = "是不是配件(0:不是，1:是)")
    private Integer isPart;
    /**
     * 配件对应装备id
     */
    @ApiModelProperty(value = "配件对应装备id")
    private Integer partParentId;
    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;
    /**
     * 密级
     */
    @ApiModelProperty(value = "密级")
    private Integer secretLevel;
    /**
     * 装备名称
     */
    @ApiModelProperty(value = "装备名称")
    private String name;
    /**
     * 装备序列号
     */
    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;
    /**
     * 生产序列号
     */
    @ApiModelProperty(value = "生产序列号")
    private String prodNumber;
    /**
     * rfid表面号
     */
    @ApiModelProperty(value = "rfid表面号")
    private String rfidSurfaceId;
    /**
     * rfid卡号
     */
    @ApiModelProperty(value = "rfid卡号")
    private String rfidCardId;
    /**
     * 所在单位
     */
    @ApiModelProperty(value = "所在单位")
    private String locationUnit;
    /**
     * 所属单位
     */
    @ApiModelProperty(value = "所属单位")
    private String ownUnit;
    /**
     * 配用范围,1-省对下纵向
     */
    @ApiModelProperty(value = "配用范围,1-省对下纵向")
    private Integer matchingRange;
    /**
     * 可见范围
     */
    @ApiModelProperty(value = "可见范围")
    private Integer invisibleRange;
    /**
     * 类型
     */
    @ApiModelProperty(value = "类型")
    private Integer type;
    /**
     * 入库类型，1-横向，2-纵向
     */
    @ApiModelProperty(value = "入库类型，1-横向，2-纵向")
    private Integer storageType;
    /**
     * 管理状态,0-不再所属单位,1-在所属单位
     */
    @ApiModelProperty(value = "管理状态,0-不再所属单位,1-在所属单位")
    private Integer manageStatus;
    /**
     * 生命状态,0-入库待审核,1-入库审核失败,2-在库,3-配发,4-维修,5,维修失败,6-退回,7-待退装,8-退装,9-待销毁,10-已销毁,11-丢失
     */
    @ApiModelProperty(value = "生命状态,0-入库待审核,1-入库审核失败,2-在库,3-配发,4-维修,5,维修失败,6-退回,7-待退装,8-退装,9-待销毁,10-已销毁,11-丢失")
    private Integer lifeStatus;
    /**
     * 锁定状态,0-未锁定可用,1-锁定不可用
     */
    @ApiModelProperty(value = "锁定状态,0-未锁定可用,1-锁定不可用")
    private Integer lockStatus = 0;
    /**
     * 创建用户id
     */
    @CreatedBy
    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    private java.util.Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy
    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private java.util.Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "入库操作人")
    @Transient
    private String storageProcessingUser;

    @ApiModelProperty(value = "入库审核人")
    @Transient
    private String storageConfirmUser;

    @ApiModelProperty(value = "从属于")
    @Transient
    private String parentDevice;

    /**
     * 检查结果(0:丢失,1:无误,2:新增)
     */
    @ApiModelProperty(value = "检查结果(0:丢失,1:无误,2:新增)")
    @Transient
    private Integer checkResult;

    @Transient
    private List<DeviceLibrary> childs = new ArrayList<>();

    public void addChildNode(DeviceLibrary deviceLibraryEntity) {
        childs.add(deviceLibraryEntity);
    }
}
