package com.tykj.dev.device.library.subject.domin;

import com.tykj.dev.device.task.subject.vo.FileVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * entity class for device_log
 * 设备履历日志
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_log set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("设备履历日志")
public class DeviceLog {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	 * 日志类型(默认0为装备日志,1为设备日志)
	 */
	@ApiModelProperty(value = "日志类型(默认0为装备日志,1为设备日志)")
	private Integer type = 0;
	/**
	* 装备id
	*/
	@ApiModelProperty(value = "装备id")
	private Integer deviceId;
	/**
	* 操作人主键id
	*/
	@ApiModelProperty(value = "操作人主键id")
	private Integer userId;
	/**
	* 操作时间
	*/
	@ApiModelProperty(value = "操作时间")
	private Date logTime;
	/**
	* 操作描述
	*/
	@ApiModelProperty(value = "操作描述")
	private String remark;
	/**
	* 相关附件信息(Ǵ作为每个附件分隔符,Ǒ作为附件内部分隔符,例如name1Ǒurl1Ǒ配发单Ǵname2Ǒurl2Ǒ入库确认单Ǵ)
	*/
	@ApiModelProperty(value = "相关附件信息(Ǵ作为每个附件分隔符,Ǒ作为附件内部分隔符,例如name1Ǒurl1Ǒ配发单Ǵname2Ǒurl2Ǒ入库确认单Ǵ)")
	private String fileDetail;
	/**
	* 创建用户id
	*/
	@ApiModelProperty(value = "创建用户id")
	@CreatedBy
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@ApiModelProperty(value = "创建时间")
	@CreatedDate
	private Date createTime;
	/**
	* 更新用户id
	*/
	@ApiModelProperty(value = "更新用户id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@ApiModelProperty(value = "更新时间")
	@LastModifiedDate
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	@ApiModelProperty(value = "操作用户")
	@Transient
	private String user;

	@ApiModelProperty(value = "操作单位")
	@Transient
	private String unit;

	@ApiModelProperty(value = "附件信息")
	@Transient
	private List<FileVo> fileVoList;

}
