package com.zjty.fp.acq.misc.utils;

import com.google.common.collect.Lists;
import com.zjty.fp.acq.misc.entity.ImportAds;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import static com.zjty.fp.acq.misc.entity.PsspCount.*;

@Slf4j
@Scope("prototype")
@Component
public class FileCreator {
    public File createFile(String subName, String catalog, String data) {
        String pathname = ImportAds.IMPORT_URL + "files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDate(subName, catalog);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path, data.getBytes());
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e);
            }
        }
        return new File(pathname + filename);
    }

    public File createFileAndZip(String countAddress, String subName, String catalog, String data) {
        String zipData = DeflaterUtils.zipString(data);
        String pathname = ImportAds.IMPORT_URL + "files/" + subName + "/" + catalog + "/";
        String filename = getPsspFileName(countAddress, subName, catalog);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path, zipData.getBytes());
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e);
            }
        }

        //生成完毕后需要更新一下count的值
        updateCount(countAddress);
        return new File(pathname + filename);
    }


    /**
     * 更新Count值，Count+1
     */
    private void updateCount(String countAddress) {
        String globalPath = "";
        if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
            alert_count += 1;
            globalPath = ImportAds.IMPORT_URL + "files/pssp/count/alert.txt";
        } else if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
            website_count += 1;
            globalPath = ImportAds.IMPORT_URL + "files/pssp/count/website.txt";
        }
        //写入到count文件中去
        Path countPath = Paths.get(countAddress);

        //再写入一份到单导另外一端供API端参考
        Path globalCountPath = Paths.get(globalPath);
        //先删除原有的count文件，再写入现有的(全局的不用删，单导会自动删)
        try {
            Files.deleteIfExists(countPath);
        } catch (IOException e) {
            log.warn("删除原count文件失败!原因:{}", e.toString());
        }

        boolean countMake = createFilePath(new File(COUNT_PATH));
        boolean globalCountMake = createFilePath(new File(GLOBAL_COUNT_PATH));

        if (countMake && globalCountMake) {
            try {
                if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
                    Files.write(countPath, String.valueOf(alert_count).getBytes());
                    log.info("[pssp] 磁盘 count_alert 值更新成功:count = {}", alert_count);
                    Files.write(globalCountPath, String.valueOf(alert_count).getBytes());
                    log.info("[pssp] 全局 count_alert 值更新成功:count = {}", alert_count);

                } else if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
                    Files.write(countPath, String.valueOf(website_count).getBytes());
                    log.info("[pssp] 磁盘 count_website 值更新成功:count = {}", website_count);
                    Files.write(globalCountPath, String.valueOf(website_count).getBytes());
                    log.info("[pssp] 全局 count_website 值更新成功:count = {}", website_count);
                }
            } catch (IOException e) {
                log.info("[pssp]生成文件时出现异常：" + e);
            }
        }
    }

    public File createFileNoTime(String subName, String catalog, String data) {
        String pathname = "/files/" + subName + "/" + catalog + "/";
        String filename = subName + "-" + catalog + ".txt";
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path, data.getBytes());
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e);
            }
        }
        return new File(pathname + filename);
    }

    public File createFileInUTF(String subName, String catalog, Long index, List<String> list) {
        String pathname = "/files/" + subName + "/" + catalog + "/";
        String filename = subName + "-" + catalog + "-" + index + ".txt";
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path, list);
            } catch (IOException e) {
                log.info("生成文件时出现异常: " + e);
            }
        }
        return new File(pathname + filename);
    }

    public File createFile(String subName, String catalog, List<String> list) {
        String pathname = "/files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDate(subName, catalog);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path, list);
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e.getMessage());
            }
        }
        return new File(pathname + filename);
    }

    public File createFileStms(String subName, String catalog, List<String> list) {
        String pathname = "/files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDateStms(subName, catalog);
        String fileNameTmp = getFileNameByDateStmsTmp(subName, catalog);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                File file = File.createTempFile(filename, ".tmp", new File(pathname));
                Files.write(path, list);
                new File(pathname + filename).renameTo(new File(pathname + fileNameTmp));
                file.delete();
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e.getMessage());
            }
        }
        return new File(pathname + filename);
    }

    public File createFileStms(String subName, String catalog, List<String> list, int count) {
        String pathname = "/files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDateStms(subName, catalog, count);
        String fileNameTmp = getFileNameByDateStmsTmp(subName, catalog, count);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                File file = File.createTempFile(filename, ".tmp", new File(pathname));
                Files.write(path, list);
                new File(pathname + filename).renameTo(new File(pathname + fileNameTmp));
                file.delete();
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e.getMessage());
            }
        }
        return new File(pathname + filename);
    }

    /**
     * 根据日期生成文件名
     * 以天为单位
     * 文件名格式：平台名-种类-时间（yyyyMMdd）.txt
     */
    private String getFileNameByDate(String subName, String catalog) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return subName + "-" + catalog + "-" + sdf.format(new Date()) + ".txt";
    }

    private String getFileNameByDateStms(String subName, String catalog, int count) {
        return subName + "-" + catalog + count + ".tmp";
    }

    private String getFileNameByDateStmsTmp(String subName, String catalog, int count) {
        return subName + "-" + catalog + count + ".txt";
    }

    private String getFileNameByDateStms(String subName, String catalog) {
        return subName + "-" + catalog + ".tmp";
    }

    private String getFileNameByDateStmsTmp(String subName, String catalog) {
        return subName + "-" + catalog + ".txt";
    }

    private String getPsspFileName(String countAddress, String subName, String catalog) {

        //count 先从内存里取读 内存里读不到从磁盘读
        int count = -1;
        if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
            count = alert_count;

        } else if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
            count = website_count;

        }

        //如果count为初始值-1,则代表还没有从文件中读取之前的记录
        if (count == -1) {
            //读取文件获得文件编号后缀值
            Path path = Paths.get(countAddress);
            List<String> data = Lists.newArrayList();

            try {
                data = Files.readAllLines(path);
            } catch (IOException e) {
                log.info("[pssp]读取文件时出现异常：" + e);
            }
            count = data.get(0) == null ? 0 : Integer.parseInt(data.get(0));
        }

        if (count <= 0) count = 0;

        String psspFileName = subName + "-" + catalog + count + ".txt";
        log.info("[pssp] 成功生成文件名:{}", psspFileName);

        return psspFileName;
    }

    /**
     * 生成指定的文件夹路径
     * 若文件夹不存在则创建
     */
    private boolean createFilePath(File file) {
        return file.exists() || file.mkdirs();
    }

}
