package com.zjty.fp.acq.pssp.base.beans;

import com.google.common.collect.Lists;
import com.zjty.fp.acq.misc.entity.ImportAds;
import com.zjty.fp.acq.pssp.subject.service.RegionService;
import com.zjty.fp.acq.pssp.subject.service.WebsiteService;
import com.zjty.fp.acq.pssp.task.CollectDataTask;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

import static com.zjty.fp.acq.misc.entity.PsspCount.*;

/**
 * PsspInitialRunner 初始化Runner程序
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-08 at 17:15
 */
@Slf4j
@Configuration
public class PsspInitialRunner {


    @Autowired
    private WebsiteService websiteService;

    @Autowired
    private RegionService regionService;

    @Autowired
    private CollectDataTask task;

    @Order(100)
    @Bean
    public CommandLineRunner initializeDictMap() {
        return args -> {
            initCount("COUNT_ALERT", COUNT_ADDRESS_ALERT);
            initCount("COUNT_WEBSITE", COUNT_ADDRESS_WEBSITE);
            task.fetchHisData();
        };
    }

    private void initCount(String countFileName, String CountAddress) {
        log.info("[pssp] 正在尝试初始化 {} 文件", countFileName);

        boolean countExists = Files.exists(Paths.get(CountAddress));
        String GlobalCountAddress = "";
        if (countFileName.equals("COUNT_ALERT")){
            GlobalCountAddress = ImportAds.IMPORT_URL + "files/pssp/count/alert.txt";
        }else {
            GlobalCountAddress = ImportAds.IMPORT_URL + "files/pssp/count/website.txt";
        }

        boolean globalCountExists = Files.exists(Paths.get(GlobalCountAddress));

        log.info("[pssp] 创建本地Count文件");
        int localCount = createCountFile(countFileName, CountAddress, COUNT_PATH, countExists, 0);

        log.info("[pssp] 创建全局Count文件");
        createCountFile(countFileName, GlobalCountAddress, GLOBAL_COUNT_PATH, globalCountExists, localCount);

    }

    private int createCountFile(String countFileName, String CountAddress, String dirPath, boolean countExists, int initCount) {
        int countVar;
        if (countExists) {
            log.info("[pssp] 磁盘已存在 {} 文件，跳过初始化流程，将磁盘的 {} 读取入内存中", countFileName, countFileName);
            //读取文件获得文件编号后缀值
            Path path = Paths.get(CountAddress);
            List<String> data = Lists.newArrayList();

            try {
                data = Files.readAllLines(path);
            } catch (IOException e) {
                log.info("读取文件时出现异常：" + e);
            }
            countVar = data.get(0) == null ? 0 : Integer.parseInt(data.get(0));

            if (CountAddress.equals(COUNT_ADDRESS_ALERT)) {
                alert_count = countVar;
            } else if (CountAddress.equals(COUNT_ADDRESS_WEBSITE)) {
                website_count = countVar;
            }

        } else {
            log.info("[pssp] 磁盘不存在 {} 文件，初始化 {} 文件", countFileName, countFileName);
            boolean countMake = createFilePath(new File(dirPath));

            countVar = 0;
            if (dirPath.equals(GLOBAL_COUNT_PATH)) {
                countVar = initCount;
                log.info("[pssp] 初始化全局count值为本地count值: {}", countVar);
            }

            if (countMake) {
                try {
                    Files.write(Paths.get(CountAddress), String.valueOf(countVar).getBytes());
                    log.info("[pssp] 磁盘 {} 值更新成功:count = {}", countFileName, countVar);
                } catch (IOException e) {
                    log.info("[pssp] 生成文件时出现异常：" + e);
                }
            }
            log.info("[pssp] 初始化 {} 文件完毕!", countFileName);

            if (CountAddress.equals(COUNT_ADDRESS_ALERT)) {
                alert_count = countVar;
            } else if (CountAddress.equals(COUNT_ADDRESS_WEBSITE)) {
                website_count = countVar;
            }

        }
        return countVar;
    }

    private boolean createFilePath(File file) {
        return file.exists() || file.mkdirs();
    }


}
