package com.zjty.fp.acq.pssp.subject.controller;


import com.zjty.fp.acq.pssp.subject.service.AlertService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author matrix
 */
@RestController
@RequestMapping("/pssp/test")
public class PsspTestController {


    @Autowired
    AlertService alertService;

    /**
     * 抓取所有报警数据(当前月)
     */
    @GetMapping("/alerts/all")
    public ResponseEntity<String> fetchAllAlerts(
            @RequestParam("year") int year,
            @RequestParam("month") int month,
            @RequestParam("day") int day
    ) {
//        alertService.fetchAllData(null);
        return ResponseEntity.ok(year + "-" + month + "-" + day + " time alerts fetch job is running success");
    }

}
