package com.zjty.fp.acq.pssp.subject.entity;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

/**
 * TimeTup.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/1 at 3:16 下午
 */
public class TimeTup {
    private Date startTime;

    private LocalDateTime localStartTime;

    private Date endTime;

    private LocalDateTime localEndTime;

    public TimeTup(LocalDateTime startTime) {
        setStartTime(startTime);
        LocalDateTime endTime = startTime.plusHours(24);
        setEndTime(endTime);

    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = startTime.atZone(zoneId).toInstant();
        this.startTime = Date.from(instant);
        this.localStartTime = startTime;

    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = endTime.atZone(zoneId).toInstant();
        this.endTime = Date.from(instant);
        this.localEndTime = endTime;

    }

    public LocalDateTime getLocalStartTime() {
        return localStartTime;
    }

    public LocalDateTime getLocalEndTime() {
        return localEndTime;
    }
}
