package com.zjty.fp.acq.pssp.subject.entity.location;

import lombok.*;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * RemoteRegion. 源仓库地区表
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-08 at 15:46
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "pssp_region")
public class Region {

    /**
     * 地区编号
     */
    @Id
    @GenericGenerator(name = "myGen", strategy = "assigned")
    @GeneratedValue(generator = "myGen")
    private String code;

    /**
     * 地区名称
     */
    private String name;

    /**
     * 地区短名称
     */
    private String shortName;

    /**
     * 地区等级
     */
    private Integer level;

    /**
     * 是否被删除
     */
    private Integer deleted;


    /**
     * 该属性用于提供默认为空值的区域对象
     */
    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    @Transient
    private static Region defaultRegion = new Region(
            "99999",
            "示例区域",
            "示例区域",
            0,
            0
    );

    public static Region defaultInstance() {
        return defaultRegion;
    }


}
