package com.zjty.fp.acq.pssp.subject.entity.remote;

import com.zjty.fp.acq.pssp.subject.entity.location.Website;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * fusion-platform.
 *
 * @author : Matrix [xhyrzldf@foxmail.com]
 * @Date : 18-9-3
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Table(name = "t_web")
public class RemoteWebsite {

    @Id
    @GeneratedValue
    private Long id;

    private String entry;

    private String name;

    private String scope;

    private String host;

    private String domain;

    private String contact;

    private String phone;

    private String unit;

    private Integer codeOrg;

    private Integer idWebCategory;

    @Column(name = "level_")
    private Integer level;

    private Integer statusApprove;

    private Integer statusWeb;

    private Integer statusCollect;

    private Integer statusRun;

    private Integer statusError;

    public Website toDo() {
        ModelMapper mapper = new ModelMapper();
        mapper.getConfiguration().setAmbiguityIgnored(true);
        Website website = mapper.map(this, Website.class);
        return website;
    }

}
