package com.zjty.fp.acq.pssp.subject.entity.vo;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 今日报警相关数据
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 18-11-7 .
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "pssp今日报警数据模型", description = "pssp今日报警数据,包含了不同类型的报警数据的数据统计")
public class TodayData implements Serializable {


    private static final long serialVersionUID = -7172206671206234291L;

    @JsonPropertyOrder("1")
    @ApiModelProperty(value = "今日报警总数")
    private int count;

    @JsonPropertyOrder("2")
    @ApiModelProperty(value = "今日网页类数据报警数")
    private int webs;

    @JsonPropertyOrder("4")
    @ApiModelProperty(value = "今日图片类数据报警数")
    private int images;

    @JsonPropertyOrder("4")
    @ApiModelProperty(value = "今日压缩包类数据报警数")
    private int archives;

    @JsonPropertyOrder("5")
    @ApiModelProperty(value = "今日文档类数据报警数")
    private int docs;

    @JsonPropertyOrder("6")
    @ApiModelProperty(value = "今日媒体类数据报警数")
    private int medias;

    @JsonPropertyOrder("7")
    @ApiModelProperty(value = "今日红色报警数")
    private int red;

    @JsonPropertyOrder("8")
    @ApiModelProperty(value = "今日黄色报警数")
    private int yellow;

    @JsonPropertyOrder("9")
    @ApiModelProperty(value = "今日疑似报警数")
    private int suspect;

    /**
     * 用于累加今日对象里的数据，该方法是函数式安全的，即不会对参与计算的两个对象的本身属性进行改动
     *
     * @param other 另一个今日对象
     * @return 一个新的今日数据对象s
     */
    public TodayData add(TodayData other) {
        return new TodayData(
                this.count + other.getCount(),
                this.webs + other.getWebs(),
                this.images + other.getImages(),
                this.archives + other.getArchives(),
                this.docs + other.getDocs(),
                this.medias + other.getMedias(),
                this.red + other.getRed(),
                this.yellow + other.getYellow(),
                this.suspect + other.getSuspect()
        );
    }

}
