package com.zjty.fp.acq.pssp.subject.repository.remote;

import com.zjty.fp.acq.pssp.subject.entity.remote.RemoteAlert;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @author matrix
 */
@Repository
public interface RemoteAlertRepository extends JpaRepository<RemoteAlert, Long>,
        JpaSpecificationExecutor<RemoteAlert> {

    /**
     * 抓取指定时间之后的源数据
     *
     * @return 源报警数据集合
     */
    @Query("select o from RemoteAlert o where o.tmFetch >= ?1 and o.tmFetch < ?2")
    List<RemoteAlert> findDataFromTime(Date starTime, Date endTime);

    /**
     * 抓取指定id之后的源数据
     *
     * @param id 源数据的主键id
     * @return 源报警数据集合
     */
    @Query("select o from RemoteAlert o where o.id > ?1")
    List<RemoteAlert> findDataFromId(Long id);

}
