package com.zjty.fp.acq.pssp.task;


import com.zjty.fp.acq.misc.utils.DateTimeUtil;
import com.zjty.fp.acq.pssp.base.aspect.EnablePsspSchProtect;
import com.zjty.fp.acq.pssp.base.aspect.PsspScheduleTrigger;
import com.zjty.fp.acq.pssp.subject.entity.TimeTup;
import com.zjty.fp.acq.pssp.subject.repository.remote.RemoteAlertRepository;
import com.zjty.fp.acq.pssp.subject.service.AlertService;
import com.zjty.fp.acq.pssp.subject.service.RegionService;
import com.zjty.fp.acq.pssp.subject.service.WebsiteService;
import com.zjty.fp.acq.pssp.utils.DicMapUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * <p>采集数据任务类</p>
 * 有以下任务
 * <li>采集所有历史数据</li>
 * <li>采集更新的增量数据</li>
 * 该类的的计划任务是否执行由变量{@link #trigger}控制，实现逻辑由AOP{@link PsspScheduleTrigger}控制,
 * 由{@link EnablePsspSchProtect}该注解触发
 *
 * @author : Matrix [xhyrzldf@foxmail.com]
 */
@SuppressWarnings("unused")
@Slf4j
@Configuration
public class CollectDataTask {

    /**
     * 用于控制计划任务的开关,一般来讲开关默认开启,当进行历史数据同步的时候,开关关闭
     */
    public static boolean trigger = true;
    public static LocalDate dynamicNow;
    private static Queue<TimeTup> dateList = new ArrayDeque<>();
    private static String dynamicTableMonth;
    private static Map<String, Long> mcMap = new HashMap<>();

    @Autowired
    private AlertService alertService;

    @Autowired
    private WebsiteService websiteService;

    @Autowired
    private RegionService regionService;

    private int count = 0;

    private int checkCount = 0;

    @Autowired
    private RemoteAlertRepository remotePsspRep;

    public static String getDynamicTableMonth() {
        return dynamicTableMonth;
    }

    public static void setDynamicTableMonth(LocalDate time) {
        dynamicTableMonth = time.format(DateTimeFormatter.ofPattern("yyyyMM"));
        dynamicNow = time;
    }

    public static void setDynamicTableMonth(Date time) {
        dynamicTableMonth = DateTimeUtil.formatDateTimetoString(time, "yyyyMM");
    }


    /**
     * 抓取更新的网站的数据,当前为1h/次
     */
    @EnablePsspSchProtect
    @Scheduled(cron = "17 11 0/1 * * ?")
    public void collectWebsiteData() {
        log.info("[pssp] [定时任务]抓取更新的网站数据");
        websiteService.fetchUpdatedData();
    }

    /**
     * 抓取更新的地区的数据,当前为1h/次
     */
    @EnablePsspSchProtect
//    @Scheduled(cron = "0 0 0/1 * * ?")
    public void collectRegionData() {
        log.info("[pssp] [定时任务]抓取更新的区域数据");
        regionService.fetchUpdatedData();
    }

    /**
     * 抓取更新的报警数据,当前5min/次
     */
    @EnablePsspSchProtect
    @Scheduled(cron = "33 0/5 * * * ?")
    public void collectAlertData() {
        log.info("[pssp] [定时任务] 抓取更新的报警数据");
        alertService.fetchUpdatedData();
    }

    /**
     * 用于检查计划任务开关的任务，如果开关连续5次检查失败，则手动打开
     * 该任务每30分钟执行一次
     */
    @Scheduled(cron = "0 0/30 * * * ?")
    public void checkTrigger() {
        log.info("[pssp] 开关检查任务，当前trigger为 {}", trigger);
        if (trigger == false) {
            checkCount++;
            log.info("[pssp] 记录一次开关关闭次数,当前次数为 : {}", checkCount);
        }

        if (checkCount >= 5) {
            log.info("[pssp] 检测到开关关闭时间过长,当前关闭次数为 {} ,重新打开计划任务开关", checkCount);
            trigger = true;
            checkCount = 0;
        }
    }

    /**
     * 在每个月月初的第10分钟，执行一次上个月的数据丢失补偿任务,大体逻辑如下
     * <li>1.关闭其他计划任务</li>
     * <li>2.将当前动态处理的表时间更改为上个月时间</li>
     * <li>3.执行数据更新任务</li>
     * <li>4.更正时间,开启其他计划任务></li>
     */
    @Scheduled(cron = "0 10 0 1 * ?")
    @EnablePsspSchProtect
    public void replenishMysqlDataMonthly() {
        log.info("[pssp] [定时任务] 正在执行月末数据补偿任务,暂停其他计划任务,要补偿的月份数据是 {}", LocalDate.now().minusMonths(1L).toString());
        setDynamicTableMonth(LocalDate.now().minusMonths(1L));
        alertService.fetchUpdatedData();
        log.info("[pssp] [定时任务] 月末数据补偿任务执行完毕,更正时间,开启其他计划任务");
        setDynamicTableMonth(LocalDate.now());
    }


    /**
     * 每个小时运行补充任务
     */
    @Scheduled(cron = "0 0 0/1 * * ?")
//    @Scheduled(cron = "30 * * * * ?")
    @EnablePsspSchProtect
    public void fetchHisData() {

        log.info("[pssp] 丢失数据补充任务开始...");
        //更新mcMap 文件中读取需要补充的数据 key:2021-4,value:0
        mcMap = DicMapUtil.readMonthFile();

        mcMap.forEach((ms, value) ->{
            String[] split = ms.split("-");
            Integer year = Integer.valueOf(split[0]);
            Integer month = Integer.valueOf(split[1]);
            //如果一样，则不补数据 如果当前count值大于上一次count值，则补充数据并且更新count值
            setDynamicTableMonth(LocalDate.of(year, month, 1));
            Long lmc = value;
            long cmc = remotePsspRep.count();
            if (lmc == cmc) {
                log.info("[pssp] {}-{} 月没有找到丢失的数据需要补充...", year,month);
            } else if (cmc > lmc) {
                log.info("[pssp] 检测到{}-{} 需要补充丢失的数据，丢失的数据量为 {} 条", year,month, cmc - lmc);
                //补充数据
                alertService.fetchUpdatedData();
                //更新count值
                mcMap.put(ms, cmc);
                DicMapUtil.updateMonthFile(mcMap);
            }

        } );

        //将时间重新set回去
        setDynamicTableMonth(LocalDate.now());

    }
}
