package com.zjty.fp.acq.pssp.utils;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.zjty.fp.acq.misc.entity.PsspCount.FIX_MONTH_PATH;

/**
 * DicMapUtil.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/7/29 at 10:54 上午
 */
@Slf4j
public class DicMapUtil {

    /**
     * 将MAP转为形如k,v的字符串保存到文件中去,文件名为/files/map/website/dictMap.txt
     */
    public static File createDictFile(String catalog, Map<String, Integer> idMap) {
        String pathname = "files/map/" + catalog + "/";
        String filename = "dictMap.txt";
        Path path = Paths.get(pathname + filename);

        //每次写入前先删除文件从而达到更新的效果
        try {
            log.info("[pssp] 正在删除原始dict文件:{}", pathname + filename);
            Files.deleteIfExists(path);
            log.info("[pssp] 删除成功，删除文件名为:{}", pathname + filename);
        } catch (IOException e) {
            log.warn("[pssp] 删除文件时发生异常,信息为:{}", e.toString());
        }

        boolean make = createFilePath(new File(pathname));
        List<String> stringList = new ArrayList<>();
        idMap.forEach((k, v) -> stringList.add(k + "," + v));
        log.info("[pssp] 正在重新生成dict文件 : {}", path);
        if (make) {
            try {
                Files.write(path, stringList);
                log.info("[pssp] 重新生成 {} 文件成功", path);
            } catch (IOException e) {
                log.info("[pssp]生成文件时出现异常：{}", e.toString());
            }
        }
        return new File(pathname + filename);

    }

    public static void updateMonthFile(Map<String,Long> mcMap){
        Path path = Paths.get(FIX_MONTH_PATH);

        //每次写入前先删除文件从而达到更新的效果
        try {
            log.info("[pssp] 正在删除原始month文件:{}", FIX_MONTH_PATH);
            Files.deleteIfExists(path);
            log.info("[pssp] 删除成功，删除文件名为:{}", FIX_MONTH_PATH);
        } catch (IOException e) {
            log.warn("[pssp] 删除文件时发生异常,信息为:{}", e.toString());
        }

        boolean make = createFilePath(new File("/files/pssp/fix/"));
        List<String> stringList = new ArrayList<>();
        mcMap.forEach((k, v) -> stringList.add(k + "," + v));
        log.info("[pssp] 正在重新生成month文件 : {}", path);
        if (make) {
            try {
                Files.write(path, stringList);
                log.info("[pssp] 重新生成 {} 文件成功", path);
            } catch (IOException e) {
                log.info("[pssp]生成文件时出现异常：{}", e.toString());
            }
        }

    }

    public static Map<String,Long> readMonthFile(){
        List<String> data = Lists.newArrayList();
        Path path = Paths.get(FIX_MONTH_PATH);
        try {
            data = Files.readAllLines(path);
        } catch (IOException e) {
            log.info("读取文件时出现异常：" + e);
        }

        //得到的data是形如2021-4,0这样的字符串 map key : 2021-4 value : 0
        Map<String, Long> mcMap = new HashMap<>();

        for (String d : data) {
            String[] split = d.split(",");
            if (split.length != 2) continue;
            mcMap.put(split[0], Long.valueOf(split[1]));
        }

        return mcMap;
    }

    public static Map<String, Integer> readDictFile(String catalog) {
        List<String> data = Lists.newArrayList();
        String localFilePath = "files/map/" + catalog + "/";
        String fileName = "dictMap.txt";
        File file = new File(localFilePath + fileName);
        Path path = Paths.get(localFilePath + fileName);
        try {
            data = Files.readAllLines(path);
        } catch (IOException e) {
            log.info("读取文件时出现异常：" + e);
        }
        //得到的data是形如2018-10,5的字符串
        Map<String, Integer> map = new HashMap<>();

        for (String d : data) {
            String[] strings = d.split(",");
            if (strings.length != 2) continue;
            map.put(strings[0], Integer.valueOf(strings[1]));
        }
        return map;
    }

    /**
     * 生成指定的文件夹路径
     * 若文件夹不存在则创建
     */
    private static boolean createFilePath(File file) {
        return file.exists() || file.mkdirs();
    }
}
