package com.zjty.fp.acq.union.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.zjty.fp.acq.pssp.config.algorithm.AlertPreShardAlgo;
import com.zjty.fp.acq.pssp.config.algorithm.AlertRangeShardAlgo;
import io.shardingsphere.api.config.ShardingRuleConfiguration;
import io.shardingsphere.api.config.TableRuleConfiguration;
import io.shardingsphere.api.config.strategy.StandardShardingStrategyConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import static io.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory.createDataSource;

@ComponentScan
@Configuration
public class DataSourceConfig {

    @Autowired
    private Environment env;


    /**
     * fp-simc数据源，用于pssp平台采集数据
     */
    @Bean(name = "remoteDataSource")
    @Qualifier("remoteDataSource")
    @Primary
    @ConfigurationProperties(prefix = "spring.datasource.remote")
    public DataSource primaryDataSource() {
        return DruidDataSourceBuilder.create().build();
    }
}
