package com.zjty.fp.acq.vomp.subject.entity.remotedo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author C
 * 地区
 * 里面包含
 * 监测终端数
 * 报警数
 * 报警率等等
 */
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Data
@Table(name = "b_zone")
public class Zone {

    /**
     * id,不知用途，有些为null
     */
    @Column(name = "zoneid0")
    private String zoneId0;

    /**
     * 主id
     */
    @Id
    @Column(name = "zoneid")
    private String zoneId;

    /**
     * 地区名字
     */
    @Column(name = "zonename")
    private String zoneName;

    /**
     * 均为null
     */
    @Column(name = "bmp")
    private String bmp;

    /**
     * 坐标x
     */
    @Column(name = "xorigin")
    private String xOrigin;

    /**
     * 坐标y
     */
    @Column(name = "yorigin")
    private String yOrigin;

    /**
     * 不详字段
     */
    @Column(name = "xterminus")
    private String xTerminus;

    /**
     * 不详字段
     */
    @Column(name = "yterminus")
    private String yTerminus;

    /**
     * 背景颜色
     */
    @Column(name = "bg")
    private String bg;

    /**
     * 父地区id
     */
    @Column(name = "parentid")
    private String parentID;

    /**
     * 等级
     */
    @Column(name = "levelid")
    private Integer levelID;

    /**
     * 不详字段
     */
    @Column(name = "zonecount")
    private Integer zoneCount;

    /**
     * 监控终端数量
     */
    @Column(name = "zonepccount")
    private String zonePcCount;

    /**
     * 不详
     */
    @Column(name = "xml", columnDefinition = "text")
    private String xmls;

    /**
     * 0或1,不详
     */
    @Column(name = "enterable")
    private Integer enterable;

    /**
     * 不详
     */
    @Column(name = "zoneinformant")
    private String zoneInformant;

    /**
     * 不详
     */
    @Column(name = "zoneapproved")
    private String zoneApproved;

    /**
     * 操作者,admin,null，不确定
     */
    @Column(name = "zoneoperator")
    private String zoneOperator;

    /**
     * 时间,用途不详
     */
    @Column(name = "zonestamp")
    private String zoneStamp;

    /**
     * 涉密计算机数量
     */
    @Column(name = "zonepacount")
    private String zonePaCount;
}
