package com.zjty.fp.acq.vomp.subject.service.updater.impl;

import com.zjty.fp.acq.misc.utils.FileCreator;
import com.zjty.fp.acq.misc.utils.JacksonUtil;
import com.zjty.fp.acq.vomp.subject.entity.remotedo.PcLog;
import com.zjty.fp.acq.vomp.subject.repository.remote.*;
import com.zjty.fp.acq.vomp.subject.service.updater.VompFetcher;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.zjty.fp.acq.vomp.base.enums.VompCatalogs.*;
import static com.zjty.fp.acq.vomp.base.enums.VompPlatform.PLATFORM;

@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Slf4j
@Service
public class VompFetcherImpl implements VompFetcher {
    @Autowired
    ChkRoutesRepository chkRoutesRepository;
    @Autowired
    ChkStatesRepository chkStatesRepository;
    @Autowired
    PcLogRepository pcLogRepository;
    @Autowired
    ServerStatusRepository serverStatusRepository;
    @Autowired
    ZoneRepository zoneRepository;
    @Autowired
    FileCreator fileCreator;

    @Override
    public void fetchData() {
        //5种数据分别写入
        uploadChkRoutes();
        uploadChkStates();
        uploadPcLog();
        uploadServerStatus();
        uploadZone();
    }

    private void createFileThenSaveFile(String catalog, String data){
        String subName = PLATFORM.getName();
        fileCreator.createFile(subName, catalog, data);
        log.info("[{}] {}写入完毕",subName,catalog);
    }

    private void uploadChkRoutes() {
        String data = JacksonUtil.toJSon(chkRoutesRepository.findAll());
        createFileThenSaveFile(CHKROUTES.getName(),data);
    }

    private void uploadChkStates() {
        String data = JacksonUtil.toJSon(chkStatesRepository.findAll());
        createFileThenSaveFile(CHKSTATES.getName(),data);
    }

    private void uploadPcLog() {
        List<PcLog> pcLogList = pcLogRepository.findAll();
        for (PcLog log : pcLogList) {
            if (log.getRecno() == 31144) {
                log.setUnitName("中共文成县纪律检查委员会");
            }

            if (log.getRecno() == 31142) {
                log.setUnitName("中共温州市鹿城区纪律检查委员会");
            }

            if (log.getRecno() == 31138) {
                log.setUnitName("发改局");
            }

            if (log.getRecno() == 31137) {
                log.setUnitName("温州市环境保护设计科学研究院");
            }

            if (log.getRecno() == 31135) {
                log.setUnitName("县委办");
            }

        }
        String data = JacksonUtil.toJSon(pcLogList);
        createFileThenSaveFile(PCLOG.getName(),data);
    }

    private void uploadServerStatus() {
        String data = JacksonUtil.toJSon(serverStatusRepository.findAll());
        createFileThenSaveFile(SERVERSTATUS.getName(),data);

    }

    private void uploadZone() {
        String data = JacksonUtil.toJSon(zoneRepository.findAll());
        createFileThenSaveFile(ZONE.getName(),data);
    }

}
